/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.preference.field;

import io.github.albertus82.jface.preference.field.AbstractIntegerComboFieldEditor;
import io.github.albertus82.util.logging.LoggerFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Composite;

public class LongComboFieldEditor
extends AbstractIntegerComboFieldEditor<Long> {
    private static final Logger log = LoggerFactory.getLogger(LongComboFieldEditor.class);
    private static final int DEFAULT_TEXT_LIMIT = Long.toString(Long.MAX_VALUE).length() - 1;

    public LongComboFieldEditor(String name, String labelText, String[][] entryNamesAndValues, Composite parent) {
        super(name, labelText, entryNamesAndValues, parent);
        this.setMinValidValue(0L);
    }

    @Override
    protected int getDefaultTextLimit() {
        return DEFAULT_TEXT_LIMIT;
    }

    @Override
    protected String cleanValue(String value) {
        String cleanValue = super.cleanValue(value);
        try {
            return Long.valueOf(cleanValue).toString();
        }
        catch (NumberFormatException e) {
            log.log(Level.FINEST, "The value provided does not contain a parsable long:", e);
            return cleanValue;
        }
    }

    @Override
    protected void cleanComboText() {
        String oldText = this.getComboBoxControl().getText();
        String newText = oldText.trim();
        try {
            newText = this.getNameForValue(Long.valueOf(newText).toString());
        }
        catch (Exception e) {
            log.log(Level.FINEST, "Cannot determine a name for the value provided:", e);
        }
        if (!newText.equals(oldText)) {
            this.getComboBoxControl().setText(newText);
        }
    }

    @Override
    public String getValue() {
        try {
            return Long.valueOf(super.getValue()).toString();
        }
        catch (Exception e) {
            log.log(Level.FINEST, "Cannot translate the string into a Long:", e);
            return super.getValue();
        }
    }

    @Override
    protected void setValue(String value) {
        try {
            super.setValue(Long.valueOf(value).toString());
        }
        catch (Exception e) {
            log.log(Level.FINEST, "Cannot translate the string into a Long:", e);
            super.setValue(value);
        }
    }

    public Long getNumberValue() {
        return Long.valueOf(this.getValue());
    }
}

