/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.preference.field;

import io.github.albertus82.jface.listener.LongVerifyListener;
import io.github.albertus82.jface.preference.field.AbstractIntegerFieldEditor;
import io.github.albertus82.util.ISupplier;
import io.github.albertus82.util.Supplier;
import io.github.albertus82.util.logging.LoggerFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class LongFieldEditor
extends AbstractIntegerFieldEditor<Long> {
    private static final Logger log = LoggerFactory.getLogger(LongFieldEditor.class);
    private static final int DEFAULT_TEXT_LIMIT = Long.toString(Long.MAX_VALUE).length() - 1;

    public LongFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
        this.setMinValidValue(0L);
        this.getTextControl().addVerifyListener((VerifyListener)new LongVerifyListener((ISupplier<Boolean>)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return LongFieldEditor.this.getMinValidValue() == null || (Long)LongFieldEditor.this.getMinValidValue() < 0L;
            }
        }));
        this.getTextControl().addFocusListener((FocusListener)new LongFocusListener());
    }

    @Override
    protected int getDefaultTextLimit() {
        return DEFAULT_TEXT_LIMIT;
    }

    @Override
    protected void doLoad() {
        super.doLoad();
        Text text = this.getTextControl();
        if (text != null) {
            String value;
            try {
                value = Long.valueOf(this.getPreferenceStore().getString(this.getPreferenceName()).trim()).toString();
            }
            catch (NumberFormatException e) {
                log.log(Level.FINEST, "The value provided does not contain a parsable long:", e);
                value = "";
            }
            text.setText(value);
            this.oldValue = value;
        }
        this.updateFontStyle();
    }

    protected void doStore() {
        Text text = this.getTextControl();
        if (text != null) {
            if (text.getText().isEmpty() && this.isEmptyStringAllowed()) {
                this.getPreferenceStore().setValue(this.getPreferenceName(), "");
            } else {
                Long value = Long.valueOf(text.getText());
                this.getPreferenceStore().setValue(this.getPreferenceName(), value.toString());
            }
        }
    }

    @Override
    protected String getDefaultValue() {
        String defaultValue = super.getDefaultValue();
        try {
            return Long.valueOf(defaultValue).toString();
        }
        catch (NumberFormatException e) {
            log.log(Level.FINEST, "The value provided does not contain a parsable long:", e);
            return "";
        }
    }

    public Long getNumberValue() {
        return Long.valueOf(this.getStringValue());
    }

    protected class LongFocusListener
    extends FocusAdapter {
        protected LongFocusListener() {
        }

        public void focusLost(FocusEvent fe) {
            Text text = (Text)fe.widget;
            String oldText = text.getText();
            try {
                String newText = Long.toString(Long.parseLong(oldText));
                if (!oldText.equals(newText)) {
                    text.setText(newText);
                }
                LongFieldEditor.this.valueChanged();
            }
            catch (Exception e) {
                log.log(Level.FINE, "Cannot change the value of the field:", e);
            }
        }
    }
}

