/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.preference.field;

import io.github.albertus82.jface.JFaceMessages;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Locale;
import javax.xml.bind.DatatypeConverter;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class PasswordFieldEditor
extends StringFieldEditor {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private Text textField;
    protected char[] oldValue;
    protected char[] value;
    private MessageDigest messageDigest;
    private Charset charset;

    public PasswordFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
        this.init();
    }

    public PasswordFieldEditor(String name, String labelText, int width, Composite parent) {
        super(name, labelText, width, parent);
        this.init();
    }

    public PasswordFieldEditor(String name, String labelText, String hashAlgorithm, Composite parent) throws NoSuchAlgorithmException {
        super(name, labelText, parent);
        if (hashAlgorithm != null && !hashAlgorithm.isEmpty()) {
            this.messageDigest = MessageDigest.getInstance(hashAlgorithm);
            this.charset = DEFAULT_CHARSET;
        }
        this.init();
    }

    public PasswordFieldEditor(String name, String labelText, String hashAlgorithm, int width, Composite parent) throws NoSuchAlgorithmException {
        super(name, labelText, width, parent);
        if (hashAlgorithm != null && !hashAlgorithm.isEmpty()) {
            this.messageDigest = MessageDigest.getInstance(hashAlgorithm);
            this.charset = DEFAULT_CHARSET;
        }
        this.init();
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        super.doFillIntoGrid(parent, numColumns);
        Text control = this.getTextControl();
        if (control != null && !control.isDisposed() && control.getLayoutData() instanceof GridData) {
            GridData gd = (GridData)control.getLayoutData();
            gd.widthHint = control.computeSize((int)-1, (int)-1).x;
            gd.grabExcessHorizontalSpace = false;
        }
    }

    public Text getTextControl(Composite parent) {
        if (this.textField == null) {
            this.textField = new Text(parent, 0x400804);
            this.textField.setFont(parent.getFont());
            this.textField.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent ke) {
                    PasswordFieldEditor.this.valueChanged();
                }
            });
            this.textField.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent fe) {
                    if (PasswordFieldEditor.this.messageDigest != null) {
                        PasswordFieldEditor.this.textField.setText("");
                    }
                }

                public void focusLost(FocusEvent fe) {
                    PasswordFieldEditor.this.valueChanged();
                }
            });
            this.textField.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent de) {
                    PasswordFieldEditor.this.textField = null;
                }
            });
        } else {
            this.checkParent((Control)this.textField, parent);
        }
        return this.textField;
    }

    protected void doLoad() {
        if (this.textField != null) {
            this.value = this.getPreferenceStore().getString(this.getPreferenceName()).toCharArray();
            this.oldValue = this.value;
            if (this.messageDigest == null) {
                this.textField.setTextChars(this.value);
            } else {
                this.textField.setText("********");
            }
        }
    }

    protected void doLoadDefault() {
        if (this.textField != null) {
            this.textField.setTextChars(this.getPreferenceStore().getDefaultString(this.getPreferenceName()).toCharArray());
        }
        this.valueChanged();
    }

    protected void doStore() {
        this.getPreferenceStore().setValue(this.getPreferenceName(), String.valueOf(this.value));
    }

    protected synchronized void valueChanged() {
        if (this.messageDigest == null) {
            this.value = this.textField.getTextChars();
        } else {
            this.messageDigest.reset();
            this.value = DatatypeConverter.printHexBinary((byte[])this.messageDigest.digest(this.textField.getText().getBytes(this.charset))).toLowerCase(Locale.ROOT).toCharArray();
        }
        this.setPresentsDefaultValue(false);
        boolean oldState = this.isValid();
        this.refreshValidState();
        if (this.isValid() != oldState) {
            this.fireStateChanged("field_editor_is_valid", oldState, this.isValid());
        }
        if (!Arrays.equals(this.value, this.oldValue)) {
            this.fireValueChanged("field_editor_value", this.oldValue, this.value);
            this.oldValue = this.value;
        }
    }

    protected boolean checkState() {
        char[] txt;
        boolean result = this.isEmptyStringAllowed() ? true : (this.textField == null ? false : this.trimCharArray(txt = this.textField.getTextChars()).length > 0 || this.isEmptyStringAllowed());
        boolean bl = result = result && this.doCheckState();
        if (result) {
            this.clearErrorMessage();
        } else {
            this.showErrorMessage(this.getErrorMessage());
        }
        return result;
    }

    @Deprecated
    public String getStringValue() {
        if (this.textField != null) {
            return String.valueOf(this.value);
        }
        return this.getPreferenceStore().getString(this.getPreferenceName());
    }

    @Deprecated
    public void setStringValue(String value) {
        this.setCharArrayValue(value.toCharArray());
    }

    public char[] getCharArrayValue() {
        if (this.textField != null) {
            return this.value;
        }
        return this.getPreferenceStore().getString(this.getPreferenceName()).toCharArray();
    }

    public void setCharArrayValue(char[] value) {
        if (this.textField != null) {
            char[] cleanValue = value != null ? value : new char[]{};
            if (!Arrays.equals(this.textField.getTextChars(), cleanValue)) {
                this.textField.setTextChars(cleanValue);
                this.valueChanged();
            }
        }
    }

    protected char[] trimCharArray(char[] txt) {
        int st;
        int len = txt.length;
        for (st = 0; st < len && txt[st] <= ' '; ++st) {
        }
        while (st < len && txt[len - 1] <= ' ') {
            --len;
        }
        return st > 0 || len < txt.length ? Arrays.copyOfRange(txt, st, len) : txt;
    }

    protected void init() {
        this.setErrorMessage(JFaceMessages.get("err.preferences.string"));
        this.setTextLimit(8192);
    }

    protected Text getTextField() {
        return this.textField;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }
}

