/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.preference.field;

import io.github.albertus82.jface.Formatter;
import io.github.albertus82.jface.JFaceMessages;
import io.github.albertus82.jface.listener.IntegerVerifyListener;
import io.github.albertus82.jface.preference.field.FieldEditorDefault;
import io.github.albertus82.util.logging.LoggerFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.ScaleFieldEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class ScaleIntegerFieldEditor
extends ScaleFieldEditor
implements FieldEditorDefault {
    private static final Logger log = LoggerFactory.getLogger(ScaleIntegerFieldEditor.class);
    private static final Formatter formatter = new Formatter(ScaleIntegerFieldEditor.class);
    private final Text text;
    private boolean defaultToolTip = true;
    private boolean boldCustomValues = true;

    public ScaleIntegerFieldEditor(String name, String labelText, Composite parent, int min, int max, int increment, int pageIncrement) {
        super(name, labelText, parent, min, max, increment, pageIncrement);
        this.text = this.createTextControl(parent);
    }

    public Text getTextControl() {
        return this.text;
    }

    protected Text createTextControl(Composite parent) {
        Text textControl = new Text(parent, 133120);
        int widthHint = formatter.computeWidth((Control)textControl, Integer.toString(this.getMaximum()).length(), 1);
        GridDataFactory.swtDefaults().align(4, 0x1000000).hint(widthHint, -1).applyTo((Control)textControl);
        textControl.setTextLimit(Integer.toString(this.getMaximum()).length());
        textControl.addFocusListener((FocusListener)new TextFocusListener());
        textControl.addKeyListener((KeyListener)new TextKeyListener());
        textControl.addVerifyListener((VerifyListener)new IntegerVerifyListener(false));
        return textControl;
    }

    protected void adjustForNumColumns(int numColumns) {
        ((GridData)this.scale.getLayoutData()).horizontalSpan = numColumns - (this.getNumberOfControls() - 1);
    }

    public int getNumberOfControls() {
        return super.getNumberOfControls() + 1;
    }

    protected void valueChanged() {
        super.valueChanged();
        this.updateText();
    }

    protected void doLoad() {
        super.doLoad();
        this.setToolTipText();
        this.updateText();
    }

    protected String getDefaultValue() {
        String defaultValue = this.getPreferenceStore().getDefaultString(this.getPreferenceName()).trim();
        try {
            return Integer.valueOf(defaultValue).toString();
        }
        catch (NumberFormatException e) {
            log.log(Level.FINEST, "The value provided does not contain a parsable int:", e);
            return "";
        }
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.scale.setEnabled(enabled);
        this.text.setEnabled(enabled);
    }

    protected void setToolTipText() {
        if (this.defaultToolTip) {
            String defaultValue = this.getDefaultValue();
            if (this.text != null && !this.text.isDisposed() && defaultValue != null && !defaultValue.isEmpty()) {
                this.text.setToolTipText(JFaceMessages.get("lbl.preferences.default.value", defaultValue));
            }
        }
    }

    protected void updateText() {
        if (this.scale != null && !this.scale.isDisposed()) {
            this.setText(this.scale.getSelection());
        }
    }

    protected void setText(int value) {
        if (this.text != null && !this.text.isDisposed()) {
            this.text.setText(Integer.toString(value));
            formatter.updateFontStyle(this.text, this.getPreferenceStore().getDefaultInt(this.getPreferenceName()));
        }
    }

    @Override
    public boolean isDefaultToolTip() {
        return this.defaultToolTip;
    }

    @Override
    public void setDefaultToolTip(boolean defaultToolTip) {
        this.defaultToolTip = defaultToolTip;
    }

    @Override
    public boolean isBoldCustomValues() {
        return this.boldCustomValues;
    }

    @Override
    public void setBoldCustomValues(boolean boldCustomValues) {
        this.boldCustomValues = boldCustomValues;
    }

    protected class TextFocusListener
    extends FocusAdapter {
        protected TextFocusListener() {
        }

        public void focusLost(FocusEvent fe) {
            try {
                int textValue = Integer.parseInt(ScaleIntegerFieldEditor.this.text.getText());
                if (textValue > ScaleIntegerFieldEditor.this.getMaximum()) {
                    textValue = ScaleIntegerFieldEditor.this.getMaximum();
                }
                if (textValue < ScaleIntegerFieldEditor.this.getMinimum()) {
                    textValue = ScaleIntegerFieldEditor.this.getMinimum();
                }
                ScaleIntegerFieldEditor.this.setText(textValue);
                ScaleIntegerFieldEditor.this.scale.setSelection(textValue);
            }
            catch (RuntimeException e) {
                log.log(Level.FINE, "Cannot update the selection (which is the value) of the scale:", e);
                ScaleIntegerFieldEditor.this.setText(ScaleIntegerFieldEditor.this.scale.getSelection());
            }
        }
    }

    protected class TextKeyListener
    extends KeyAdapter {
        protected TextKeyListener() {
        }

        public void keyReleased(KeyEvent ke) {
            if (ScaleIntegerFieldEditor.this.boldCustomValues) {
                formatter.updateFontStyle((Text)ke.widget, ScaleIntegerFieldEditor.this.getPreferenceStore().getDefaultInt(ScaleIntegerFieldEditor.this.getPreferenceName()));
            }
        }
    }
}

