/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.preference.field;

import io.github.albertus82.jface.preference.field.AbstractIntegerComboFieldEditor;
import io.github.albertus82.util.logging.LoggerFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Composite;

public class ShortComboFieldEditor
extends AbstractIntegerComboFieldEditor<Short> {
    private static final Logger log = LoggerFactory.getLogger(ShortComboFieldEditor.class);
    private static final int DEFAULT_TEXT_LIMIT = Short.toString((short)Short.MAX_VALUE).length();

    public ShortComboFieldEditor(String name, String labelText, String[][] entryNamesAndValues, Composite parent) {
        super(name, labelText, entryNamesAndValues, parent);
        this.setMinValidValue((short)0);
        this.setMaxValidValue((short)Short.MAX_VALUE);
    }

    @Override
    protected int getDefaultTextLimit() {
        return DEFAULT_TEXT_LIMIT;
    }

    @Override
    protected String cleanValue(String value) {
        String cleanValue = super.cleanValue(value);
        try {
            return Short.valueOf(cleanValue).toString();
        }
        catch (NumberFormatException e) {
            log.log(Level.FINEST, "The value provided does not contain a parsable short:", e);
            return cleanValue;
        }
    }

    @Override
    protected void cleanComboText() {
        String oldText = this.getComboBoxControl().getText();
        String newText = oldText.trim();
        try {
            newText = this.getNameForValue(Short.valueOf(newText).toString());
        }
        catch (Exception e) {
            log.log(Level.FINEST, "Cannot determine a name for the value provided:", e);
        }
        if (!newText.equals(oldText)) {
            this.getComboBoxControl().setText(newText);
        }
    }

    @Override
    public String getValue() {
        try {
            return Short.valueOf(super.getValue()).toString();
        }
        catch (Exception e) {
            log.log(Level.FINEST, "Cannot translate the string into a Short:", e);
            return super.getValue();
        }
    }

    @Override
    protected void setValue(String value) {
        try {
            super.setValue(Short.valueOf(value).toString());
        }
        catch (Exception e) {
            log.log(Level.FINEST, "Cannot translate the string into a Short:", e);
            super.setValue(value);
        }
    }

    public Short getNumberValue() {
        return Short.valueOf(this.getValue());
    }
}

