/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.preference.field;

import io.github.albertus82.jface.listener.ShortVerifyListener;
import io.github.albertus82.jface.preference.field.AbstractIntegerFieldEditor;
import io.github.albertus82.util.ISupplier;
import io.github.albertus82.util.Supplier;
import io.github.albertus82.util.logging.LoggerFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class ShortFieldEditor
extends AbstractIntegerFieldEditor<Short> {
    private static final Logger log = LoggerFactory.getLogger(ShortFieldEditor.class);
    private static final int DEFAULT_TEXT_LIMIT = Short.toString((short)Short.MAX_VALUE).length();

    public ShortFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
        this.setMinValidValue((short)0);
        this.setMaxValidValue((short)Short.MAX_VALUE);
        this.getTextControl().addVerifyListener((VerifyListener)new ShortVerifyListener((ISupplier<Boolean>)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return ShortFieldEditor.this.getMinValidValue() == null || (Short)ShortFieldEditor.this.getMinValidValue() < 0;
            }
        }));
        this.getTextControl().addFocusListener((FocusListener)new ShortFocusListener());
    }

    @Override
    protected int getDefaultTextLimit() {
        return DEFAULT_TEXT_LIMIT;
    }

    @Override
    protected void doLoad() {
        super.doLoad();
        Text text = this.getTextControl();
        if (text != null) {
            String value;
            try {
                value = Short.valueOf(this.getPreferenceStore().getString(this.getPreferenceName()).trim()).toString();
            }
            catch (NumberFormatException e) {
                log.log(Level.FINEST, "The value provided does not contain a parsable short:", e);
                value = "";
            }
            text.setText(value);
            this.oldValue = value;
        }
        this.updateFontStyle();
    }

    protected void doStore() {
        Text text = this.getTextControl();
        if (text != null) {
            if (text.getText().isEmpty() && this.isEmptyStringAllowed()) {
                this.getPreferenceStore().setValue(this.getPreferenceName(), "");
            } else {
                Short value = Short.valueOf(text.getText());
                this.getPreferenceStore().setValue(this.getPreferenceName(), value.toString());
            }
        }
    }

    @Override
    protected String getDefaultValue() {
        String defaultValue = super.getDefaultValue();
        try {
            return Short.valueOf(defaultValue).toString();
        }
        catch (NumberFormatException e) {
            log.log(Level.FINEST, "The value provided does not contain a parsable short:", e);
            return "";
        }
    }

    public Short getNumberValue() {
        return Short.valueOf(this.getStringValue());
    }

    protected class ShortFocusListener
    extends FocusAdapter {
        protected ShortFocusListener() {
        }

        public void focusLost(FocusEvent fe) {
            Text text = (Text)fe.widget;
            String oldText = text.getText();
            try {
                String newText = Short.toString(Short.parseShort(oldText));
                if (!oldText.equals(newText)) {
                    text.setText(newText);
                }
                ShortFieldEditor.this.valueChanged();
            }
            catch (Exception e) {
                log.log(Level.FINE, "Cannot change the value of the field:", e);
            }
        }
    }
}

