/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.preference.field;

import io.github.albertus82.jface.JFaceMessages;
import io.github.albertus82.jface.preference.field.EnhancedListEditor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class UriListEditor
extends EnhancedListEditor {
    public static final String URI_SPLIT_REGEX = "\\|";
    public static final char SEPARATOR = '|';
    private final Image[] images;

    public UriListEditor(String name, String labelText, Composite parent, Integer horizontalSpan, Image ... images) {
        super(name, labelText, parent, horizontalSpan);
        this.images = images;
    }

    @Override
    protected void createButtons(Composite box) {
        this.createAddButton(box);
        this.createEditButton(box);
        this.createRemoveButton(box);
    }

    @Override
    protected String createList(String[] uris) {
        StringBuilder list = new StringBuilder();
        if (uris != null) {
            for (int index = 0; index < uris.length; ++index) {
                list.append(uris[index].trim());
                if (index == uris.length - 1) continue;
                list.append('|');
            }
        }
        return list.toString();
    }

    @Override
    protected String getNewInputObject() {
        UriDialog uriDialog = new UriDialog(this.getShell());
        uriDialog.create(JFaceMessages.get("lbl.preferences.uri.dialog.add.title"));
        if (uriDialog.open() == 0) {
            return uriDialog.getUri();
        }
        return null;
    }

    @Override
    protected String getModifiedInputObject(String value) {
        UriDialog uriDialog = new UriDialog(this.getShell());
        uriDialog.create(JFaceMessages.get("lbl.preferences.uri.dialog.edit.title"));
        uriDialog.textUri.setText(value);
        if (uriDialog.open() == 0) {
            return uriDialog.getUri();
        }
        return null;
    }

    @Override
    protected String[] parseString(String stringList) {
        if (stringList != null && !stringList.isEmpty()) {
            return stringList.trim().split(URI_SPLIT_REGEX);
        }
        return new String[0];
    }

    protected class UriDialog
    extends TitleAreaDialog {
        private static final int MAX_LENGTH = 2000;
        private Text textUri;
        private Button okButton;
        private String uri;

        public UriDialog(Shell parentShell) {
            super(parentShell);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            if (UriListEditor.this.images != null && UriListEditor.this.images.length > 0) {
                newShell.setImages(UriListEditor.this.images);
            }
        }

        public void create(String title) {
            super.create();
            this.getShell().setText(title);
            this.setTitle(title);
            this.setMessage(JFaceMessages.get("lbl.preferences.uri.dialog.message"), 1);
        }

        protected Composite createDialogArea(Composite parent) {
            Composite area = (Composite)super.createDialogArea(parent);
            Composite container = new Composite(area, 0);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container);
            GridLayoutFactory.swtDefaults().numColumns(2).equalWidth(false).applyTo(container);
            Label labelName = new Label(container, 0);
            labelName.setText(JFaceMessages.get("lbl.preferences.uri.dialog.address"));
            GridDataFactory.swtDefaults().applyTo((Control)labelName);
            this.textUri = new Text(container, 2048);
            GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.textUri);
            this.textUri.setTextLimit(2000);
            this.textUri.addModifyListener((ModifyListener)new TextModifyListener());
            return area;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            this.okButton = this.getButton(0);
            this.okButton.setText(JFaceMessages.get("lbl.button.ok"));
            this.okButton.setEnabled(false);
            Button cancelButton = this.getButton(1);
            cancelButton.setText(JFaceMessages.get("lbl.button.cancel"));
        }

        protected boolean isResizable() {
            return true;
        }

        protected void okPressed() {
            this.uri = this.textUri.getText().trim();
            super.okPressed();
        }

        public String getUri() {
            return this.uri;
        }

        private class TextModifyListener
        implements ModifyListener {
            private final Pattern asciiPattern = Pattern.compile("^\\p{ASCII}+$");
            private final Pattern uriPattern = Pattern.compile("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?");

            private TextModifyListener() {
            }

            public void modifyText(ModifyEvent me) {
                if (!this.checkUri(UriDialog.this.textUri.getText().trim())) {
                    if (UriDialog.this.okButton.isEnabled()) {
                        UriDialog.this.okButton.setEnabled(false);
                    }
                } else if (!UriDialog.this.okButton.isEnabled()) {
                    UriDialog.this.okButton.setEnabled(true);
                }
            }

            private boolean checkUri(String uri) {
                if (uri == null || uri.isEmpty()) {
                    return false;
                }
                if (!this.asciiPattern.matcher(uri).matches()) {
                    return false;
                }
                Matcher urlMatcher = this.uriPattern.matcher(uri);
                if (!urlMatcher.matches()) {
                    return false;
                }
                if (urlMatcher.group(2) == null) {
                    return false;
                }
                if (urlMatcher.group(4) == null) {
                    return false;
                }
                return urlMatcher.group(5) != null;
            }
        }
    }
}

