/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.preference.field;

import io.github.albertus82.jface.Formatter;
import io.github.albertus82.jface.JFaceMessages;
import io.github.albertus82.jface.preference.field.EditableComboFieldEditor;
import io.github.albertus82.jface.preference.field.FieldEditorDefault;
import javax.annotation.Nullable;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ValidatedComboFieldEditor
extends EditableComboFieldEditor
implements FieldEditorDefault {
    private static final Formatter formatter = new Formatter(ValidatedComboFieldEditor.class);
    private boolean valid = true;
    private String errorMessage;
    private boolean emptyStringAllowed = true;
    private boolean defaultToolTip = true;
    private boolean boldCustomValues = true;
    private ControlDecoration controlDecorator;

    public ValidatedComboFieldEditor(String name, String labelText, String[][] entryNamesAndValues, Composite parent) {
        super(name, labelText, entryNamesAndValues, parent);
        this.setErrorMessage(JFaceMessages.get("err.preferences.combo.empty"));
        this.addDecoration();
        this.getComboBoxControl().addKeyListener((KeyListener)new ValidateKeyListener());
    }

    @Override
    protected void updateValue() {
        this.cleanComboText();
        this.validate();
        this.updateFontStyle();
    }

    protected void refreshValidState() {
        this.setValid(this.checkState());
        String errMsg = this.getErrorMessage();
        if (errMsg != null && !errMsg.isEmpty()) {
            if (this.isValid()) {
                this.clearErrorMessage();
            } else {
                this.showErrorMessage(errMsg);
            }
        }
    }

    @Override
    protected void doLoad() {
        super.doLoad();
        this.setToolTipText();
        this.updateValue();
    }

    @Override
    protected void doLoadDefault() {
        super.doLoadDefault();
        this.updateFontStyle();
    }

    @Override
    protected void updateComboForValue(String value) {
        super.updateComboForValue(this.cleanValue(value));
    }

    public boolean isValid() {
        return this.valid;
    }

    protected void setValid(boolean valid) {
        this.valid = valid;
    }

    protected String getDefaultValue() {
        return this.getPreferenceStore().getDefaultString(this.getPreferenceName());
    }

    protected void setToolTipText() {
        if (this.defaultToolTip) {
            String defaultValue = this.getNameForValue(this.getDefaultValue());
            if (this.getComboBoxControl() != null && !this.getComboBoxControl().isDisposed() && defaultValue != null && !defaultValue.isEmpty()) {
                this.getComboBoxControl().setToolTipText(JFaceMessages.get("lbl.preferences.default.value", defaultValue));
            }
        }
    }

    protected void updateFontStyle() {
        String defaultValue;
        if (this.boldCustomValues && (defaultValue = this.getDefaultValue()) != null && !defaultValue.isEmpty()) {
            formatter.updateFontStyle((Control)this.getComboBoxControl(), defaultValue, this.getValue());
        }
    }

    protected void validate() {
        super.updateValue();
        boolean oldValue = this.valid;
        this.refreshValidState();
        this.fireValueChanged("field_editor_is_valid", oldValue, this.valid);
    }

    protected String cleanValue(@Nullable String value) {
        return value != null ? value.trim() : "";
    }

    protected void cleanComboText() {
        String oldText;
        String newText;
        Combo combo = this.getComboBoxControl();
        if (combo != null && !combo.isDisposed() && !(newText = this.getNameForValue((oldText = combo.getText()).trim())).equals(oldText)) {
            combo.setText(newText);
        }
    }

    protected boolean checkState() {
        if (this.getValue() == null || this.getValue().trim().isEmpty()) {
            return this.isEmptyStringAllowed();
        }
        return this.doCheckState();
    }

    protected boolean doCheckState() {
        return true;
    }

    protected void addDecoration() {
        this.controlDecorator = new ControlDecoration((Control)this.getComboBoxControl(), 16512);
        this.controlDecorator.hide();
        Image image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
        this.controlDecorator.setImage(image);
    }

    protected void showErrorMessage(String msg) {
        super.showErrorMessage(msg);
        if (this.controlDecorator != null) {
            this.controlDecorator.setDescriptionText(msg);
            this.controlDecorator.show();
        }
    }

    protected void clearErrorMessage() {
        super.clearErrorMessage();
        if (this.controlDecorator != null && this.isValid()) {
            this.controlDecorator.hide();
        }
    }

    protected ControlDecoration getControlDecorator() {
        return this.controlDecorator;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String message) {
        this.errorMessage = message;
    }

    public boolean isEmptyStringAllowed() {
        return this.emptyStringAllowed;
    }

    public void setEmptyStringAllowed(boolean emptyStringAllowed) {
        this.emptyStringAllowed = emptyStringAllowed;
    }

    @Override
    public boolean isDefaultToolTip() {
        return this.defaultToolTip;
    }

    @Override
    public void setDefaultToolTip(boolean defaultToolTip) {
        this.defaultToolTip = defaultToolTip;
    }

    @Override
    public boolean isBoldCustomValues() {
        return this.boldCustomValues;
    }

    @Override
    public void setBoldCustomValues(boolean boldCustomValues) {
        this.boldCustomValues = boldCustomValues;
    }

    protected class ValidateKeyListener
    extends KeyAdapter {
        protected ValidateKeyListener() {
        }

        public void keyReleased(KeyEvent ke) {
            ValidatedComboFieldEditor.this.validate();
        }
    }
}

