/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.preference.field;

import io.github.albertus82.jface.JFaceMessages;
import io.github.albertus82.jface.preference.field.EnhancedStringFieldEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class WrapStringFieldEditor
extends EnhancedStringFieldEditor {
    public static final int DEFAULT_TEXT_HEIGHT = 4;
    private Text textField;

    public WrapStringFieldEditor(String name, String labelText, Composite parent) {
        this(name, labelText, parent, 4);
    }

    public WrapStringFieldEditor(String name, String labelText, Composite parent, int height) {
        super(name, labelText, parent);
        this.adjustTextHeight(height);
        this.setErrorMessage(JFaceMessages.get("err.preferences.string"));
        this.setTextLimit(8192);
    }

    public Text getTextControl(Composite parent) {
        if (this.textField == null) {
            this.textField = new Text(parent, 2626);
            this.textField.setFont(parent.getFont());
            this.textField.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent ke) {
                    WrapStringFieldEditor.this.valueChanged();
                }
            });
            this.textField.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent fe) {
                    WrapStringFieldEditor.this.valueChanged();
                }
            });
            this.textField.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent de) {
                    WrapStringFieldEditor.this.textField = null;
                }
            });
        } else {
            this.checkParent((Control)this.textField, parent);
        }
        return this.textField;
    }

    protected void adjustTextHeight(int height) {
        if (this.getTextControl().getLayoutData() instanceof GridData) {
            GridData gd = (GridData)this.getTextControl().getLayoutData();
            gd.heightHint = this.getTextControl().getLineHeight() * height;
            gd.widthHint = 0;
        }
    }
}

