/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.preference.page;

import io.github.albertus82.jface.EnhancedErrorDialog;
import io.github.albertus82.jface.JFaceMessages;
import io.github.albertus82.jface.preference.IPreference;
import io.github.albertus82.jface.preference.IPreferencesCallback;
import io.github.albertus82.jface.preference.StaticLabelsAndValues;
import io.github.albertus82.jface.preference.page.FieldEditorWrapper;
import io.github.albertus82.jface.preference.page.IPageDefinition;
import io.github.albertus82.util.NewLine;
import io.github.albertus82.util.logging.LoggerFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;

public class BasePreferencePage
extends FieldEditorPreferencePage {
    private static final Logger log = LoggerFactory.getLogger(BasePreferencePage.class);
    protected static final Map<IPreference, FieldEditorWrapper> universe = new HashMap<IPreference, FieldEditorWrapper>();
    protected final Map<IPreference, FieldEditorWrapper> fieldEditorMap = new HashMap<IPreference, FieldEditorWrapper>();
    protected Control header;
    private IPreferencesCallback preferencesCallback;
    private IPreference[] preferences;
    private IPageDefinition pageDefinition;

    public BasePreferencePage() {
        this(1);
    }

    protected BasePreferencePage(int style) {
        super(style);
    }

    public IPreferencesCallback getPreferencesCallback() {
        return this.preferencesCallback;
    }

    public void setPreferencesCallback(IPreferencesCallback preferencesCallback) {
        this.preferencesCallback = preferencesCallback;
    }

    public IPreference[] getPreferences() {
        return this.preferences;
    }

    public void setPreferences(IPreference[] preferences) {
        this.preferences = preferences;
    }

    public IPageDefinition getPageDefinition() {
        return this.pageDefinition;
    }

    public void setPageDefinition(IPageDefinition pageDefinition) {
        this.pageDefinition = pageDefinition;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Button defaultsButton = this.getDefaultsButton();
        defaultsButton.setText(JFaceMessages.get("lbl.preferences.button.defaults"));
        defaultsButton.setToolTipText(JFaceMessages.get("lbl.preferences.button.defaults.tooltip"));
        Button applyButton = this.getApplyButton();
        applyButton.setText(JFaceMessages.get("lbl.button.apply"));
    }

    protected void performApply() {
        String message;
        super.performApply();
        try {
            ((IPersistentPreferenceStore)this.getPreferenceStore()).save();
        }
        catch (IOException ioe) {
            message = JFaceMessages.get("err.preferences.save");
            log.log(Level.SEVERE, message, ioe);
            EnhancedErrorDialog.openError(this.getShell(), JFaceMessages.get("lbl.preferences.title"), message, 4, ioe, Display.getCurrent().getSystemImage(1));
        }
        try {
            this.preferencesCallback.reload();
        }
        catch (IOException ioe) {
            message = JFaceMessages.get("err.preferences.reload");
            log.log(Level.WARNING, message, ioe);
            EnhancedErrorDialog.openError(this.getShell(), JFaceMessages.get("lbl.preferences.title"), message, 2, ioe, Display.getCurrent().getSystemImage(8));
        }
    }

    protected void createFieldEditors() {
        this.header = this.createHeader();
        if (this.header != null) {
            GridDataFactory.fillDefaults().span(Short.MAX_VALUE, 1).applyTo(this.header);
            this.addSeparator();
        }
        for (IPreference preference : this.preferences) {
            if (!this.pageDefinition.equals(preference.getPageDefinition())) continue;
            if (preference.isSeparate()) {
                this.addSeparator();
            }
            Composite fieldEditorParent = this.getFieldEditorParent();
            FieldEditor fieldEditor = this.createFieldEditor(preference, fieldEditorParent);
            this.addField(fieldEditor);
            this.fieldEditorMap.put(preference, new FieldEditorWrapper(fieldEditor, fieldEditorParent));
        }
        universe.putAll(this.fieldEditorMap);
    }

    protected FieldEditor createFieldEditor(IPreference preference, Composite parent) {
        return preference.createFieldEditor(parent);
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getSource() instanceof BooleanFieldEditor) {
            BooleanFieldEditor changedBooleanFieldEditor = (BooleanFieldEditor)event.getSource();
            Boolean parentEnabled = (Boolean)event.getNewValue();
            for (Map.Entry<IPreference, FieldEditorWrapper> entry : this.fieldEditorMap.entrySet()) {
                if (!entry.getValue().getFieldEditor().equals(changedBooleanFieldEditor)) continue;
                for (IPreference childPreference : entry.getKey().getChildren()) {
                    this.updateChildrenStatus(childPreference, parentEnabled);
                }
            }
        }
    }

    protected void initialize() {
        super.initialize();
        this.updateFieldsStatus();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.updateFieldsStatus();
    }

    protected void updateChildrenStatus(IPreference childPreference, Boolean parentEnabled) {
        FieldEditorWrapper childFieldEditor = this.fieldEditorMap.get(childPreference);
        this.updateChildStatus(childFieldEditor, parentEnabled);
        if (childFieldEditor != null && childFieldEditor.getFieldEditor() instanceof BooleanFieldEditor) {
            BooleanFieldEditor childBooleanFieldEditor = (BooleanFieldEditor)childFieldEditor.getFieldEditor();
            for (IPreference descendantPreference : childPreference.getChildren()) {
                boolean childEnabled = childBooleanFieldEditor.getBooleanValue();
                this.updateChildrenStatus(descendantPreference, childEnabled && parentEnabled != false);
            }
        }
    }

    protected void updateFieldsStatus() {
        for (Map.Entry<IPreference, FieldEditorWrapper> entry : this.fieldEditorMap.entrySet()) {
            if (!(entry.getValue().getFieldEditor() instanceof BooleanFieldEditor)) continue;
            boolean parentsEnabled = this.getParentsEnabled(entry.getKey());
            for (IPreference childPreference : entry.getKey().getChildren()) {
                this.updateChildStatus(this.fieldEditorMap.get(childPreference), parentsEnabled);
            }
        }
    }

    protected boolean getParentsEnabled(IPreference preference) {
        boolean parentEnabled;
        FieldEditorWrapper fieldEditorWrapper = universe.get(preference);
        if (fieldEditorWrapper == null) {
            parentEnabled = this.getBooleanFromStore(preference);
        } else {
            try {
                parentEnabled = ((BooleanFieldEditor)fieldEditorWrapper.getFieldEditor()).getBooleanValue();
            }
            catch (NullPointerException e) {
                log.log(Level.FINE, "Field probably not initialized:", e);
                parentEnabled = this.getPreferenceStore().getBoolean(preference.getName());
            }
        }
        if (preference.getParent() != null) {
            return parentEnabled && this.getParentsEnabled(preference.getParent());
        }
        return parentEnabled;
    }

    protected void updateChildStatus(FieldEditorWrapper childFieldEditor, boolean parentEnabled) {
        if (childFieldEditor != null) {
            FieldEditor fieldEditor = childFieldEditor.getFieldEditor();
            fieldEditor.setEnabled(parentEnabled, childFieldEditor.getParent());
            if (!parentEnabled && !fieldEditor.isValid()) {
                fieldEditor.loadDefault();
                this.checkState();
            }
        }
    }

    public void updateCrossChildrenStatus() {
        for (IPreference preference : this.fieldEditorMap.keySet()) {
            IPreference parentPreference = preference.getParent();
            if (parentPreference == null || this.fieldEditorMap.containsKey(parentPreference)) continue;
            HashSet<IPreference> parents = new HashSet<IPreference>();
            while (parentPreference != null) {
                parents.add(parentPreference);
                parentPreference = parentPreference.getParent();
            }
            boolean parentsEnabled = this.checkParentsEnabled(parents);
            this.updateChildrenStatus(preference, parentsEnabled);
        }
    }

    protected boolean checkParentsEnabled(Set<IPreference> parents) {
        boolean parentEnabled = true;
        for (IPreference preference : parents) {
            FieldEditorWrapper fieldEditorWrapper = universe.get(preference);
            if (fieldEditorWrapper == null) {
                parentEnabled = this.getBooleanFromStore(preference);
            } else {
                FieldEditor fieldEditor = fieldEditorWrapper.getFieldEditor();
                if (fieldEditor instanceof BooleanFieldEditor) {
                    try {
                        parentEnabled = ((BooleanFieldEditor)fieldEditor).getBooleanValue();
                    }
                    catch (NullPointerException e) {
                        log.log(Level.FINE, "Field probably not initialized:", e);
                        parentEnabled = this.getBooleanFromStore(preference);
                    }
                }
            }
            if (parentEnabled) continue;
            break;
        }
        return parentEnabled;
    }

    protected boolean getBooleanFromStore(IPreference preference) {
        return this.getPreferenceStore().getBoolean(preference.getName());
    }

    public Control getHeader() {
        return this.header;
    }

    protected Control createHeader() {
        return null;
    }

    protected Composite createInfoComposite(Composite parent, String message) {
        Composite messageComposite = new Composite(parent, 2048);
        messageComposite.setBackground(messageComposite.getDisplay().getSystemColor(29));
        GridDataFactory.swtDefaults().applyTo((Control)messageComposite);
        GridLayoutFactory.swtDefaults().margins(2, 2).applyTo(messageComposite);
        Label messageLabel = new Label(messageComposite, 65);
        messageLabel.setText(message);
        messageLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        messageLabel.setBackground(messageLabel.getDisplay().getSystemColor(29));
        GridDataFactory.swtDefaults().applyTo((Control)messageLabel);
        return messageComposite;
    }

    protected void addSeparator() {
        Label separator = new Label(this.getFieldEditorParent(), 258);
        GridDataFactory.fillDefaults().span(Short.MAX_VALUE, 1).grab(true, false).applyTo((Control)separator);
    }

    public static StaticLabelsAndValues getNewLineComboOptions() {
        NewLine[] values = NewLine.values();
        StaticLabelsAndValues options = new StaticLabelsAndValues(values.length);
        for (NewLine newLine : values) {
            String value = newLine.name();
            options.put(value, value);
        }
        return options;
    }
}

