/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.preference.page;

import io.github.albertus82.jface.JFaceMessages;
import io.github.albertus82.jface.preference.StaticLabelsAndValues;
import io.github.albertus82.jface.preference.page.BasePreferencePage;
import io.github.albertus82.util.logging.LoggingSupport;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.swt.widgets.Control;

public class LoggingPreferencePage
extends BasePreferencePage {
    private String overriddenMessage = JFaceMessages.get("lbl.preferences.logging.overridden");

    @Override
    protected Control createHeader() {
        if (LoggingSupport.getInitialConfigurationProperty() != null) {
            return this.createInfoComposite(this.getFieldEditorParent(), this.overriddenMessage);
        }
        return null;
    }

    public final String getOverriddenMessage() {
        return this.overriddenMessage;
    }

    public final void setOverriddenMessage(String overriddenMessage) {
        this.overriddenMessage = overriddenMessage;
    }

    public static StaticLabelsAndValues getLoggingLevelComboOptions(Level min, Level max) {
        Map<Integer, Level> levels = LoggingSupport.getLevels();
        StaticLabelsAndValues options = new StaticLabelsAndValues(levels.size());
        for (Map.Entry<Integer, Level> entry : levels.entrySet()) {
            if (min != null && entry.getKey() < min.intValue() || max != null && entry.getKey() > max.intValue()) continue;
            options.put(entry.getValue().getName(), entry.getValue().getName());
        }
        return options;
    }

    public static StaticLabelsAndValues getLoggingLevelComboOptions(Level ... levels) {
        StaticLabelsAndValues options = new StaticLabelsAndValues(levels.length);
        List<Level> levelsList = Arrays.asList(levels);
        for (Level level : LoggingSupport.getLevels().values()) {
            if (!levelsList.contains(level)) continue;
            options.put(level.getName(), level.getName());
        }
        return options;
    }

    public static StaticLabelsAndValues getLoggingLevelComboOptions() {
        return LoggingPreferencePage.getLoggingLevelComboOptions(null, null);
    }
}

