/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.preference.page;

import io.github.albertus82.jface.preference.page.BasePreferencePage;
import io.github.albertus82.jface.preference.page.IPageDefinition;
import io.github.albertus82.util.ISupplier;
import io.github.albertus82.util.Localized;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public class PageDefinitionDetails {
    private String nodeId;
    private ISupplier<String> label;
    private Class<? extends BasePreferencePage> pageClass;
    private ImageDescriptor image;
    private IPageDefinition parent;

    protected PageDefinitionDetails() {
    }

    private PageDefinitionDetails(PageDefinitionDetailsBuilder builder) {
        this.nodeId = builder.nodeId;
        this.label = builder.label;
        this.pageClass = builder.pageClass;
        this.image = builder.image;
        this.parent = builder.parent;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public ISupplier<String> getLabel() {
        return this.label;
    }

    public void setLabel(ISupplier<String> label) {
        this.label = label;
    }

    public Class<? extends BasePreferencePage> getPageClass() {
        return this.pageClass;
    }

    public void setPageClass(Class<? extends BasePreferencePage> pageClass) {
        this.pageClass = pageClass;
    }

    public ImageDescriptor getImage() {
        return this.image;
    }

    public void setImage(ImageDescriptor image) {
        this.image = image;
    }

    public IPageDefinition getParent() {
        return this.parent;
    }

    public void setParent(IPageDefinition parent) {
        this.parent = parent;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nodeId == null ? 0 : this.nodeId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PageDefinitionDetails)) {
            return false;
        }
        PageDefinitionDetails other = (PageDefinitionDetails)obj;
        return !(this.nodeId == null ? other.nodeId != null : !this.nodeId.equals(other.nodeId));
    }

    public String toString() {
        return "PageDefinitionDetails [nodeId=" + this.nodeId + ", label=" + this.label + ", pageClass=" + this.pageClass + ", image=" + this.image + ", parent=" + this.parent + "]";
    }

    public static class PageDefinitionDetailsBuilder {
        private String nodeId;
        private ISupplier<String> label;
        private Class<? extends BasePreferencePage> pageClass;
        private ImageDescriptor image;
        private IPageDefinition parent;

        public PageDefinitionDetailsBuilder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public PageDefinitionDetailsBuilder label(ISupplier<String> label) {
            this.label = label;
            return this;
        }

        public PageDefinitionDetailsBuilder label(final String label) {
            this.label = new Localized(){

                @Override
                public String getString() {
                    return label;
                }
            };
            return this;
        }

        public PageDefinitionDetailsBuilder pageClass(Class<? extends BasePreferencePage> pageClass) {
            this.pageClass = pageClass;
            return this;
        }

        public PageDefinitionDetailsBuilder image(ImageDescriptor imageDescriptor) {
            this.image = imageDescriptor;
            return this;
        }

        public PageDefinitionDetailsBuilder image(Image image) {
            this.image = ImageDescriptor.createFromImage((Image)image);
            return this;
        }

        public PageDefinitionDetailsBuilder image(ImageData imageData) {
            this.image = ImageDescriptor.createFromImageData((ImageData)imageData);
            return this;
        }

        public PageDefinitionDetailsBuilder parent(IPageDefinition parent) {
            this.parent = parent;
            return this;
        }

        public PageDefinitionDetails build() {
            return new PageDefinitionDetails(this);
        }
    }
}

