/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.sysinfo;

import io.github.albertus82.jface.JFaceMessages;
import io.github.albertus82.jface.SwtUtils;
import javax.annotation.Nullable;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PropertyDetailDialog
extends Dialog {
    private static final String LBL_BUTTON_CLOSE = "lbl.button.close";
    private static final String LBL_SYSTEM_INFO_DETAIL_DIALOG_TITLE = "lbl.system.info.detail.dialog.title";
    private static final String LBL_SYSTEM_INFO_TABLE_VALUE = "lbl.system.info.table.value";
    private static final String LBL_SYSTEM_INFO_TABLE_KEY = "lbl.system.info.table.key";
    private static final int MONITOR_SIZE_DIVISOR = 3;
    private static final int MIN_TEXT_HEIGHT = 2;
    private static final int MAX_TEXT_HEIGHT = 5;
    private static final int WRAP_LENGTH = 80;
    @Nullable
    protected final String key;
    protected final String value;

    public PropertyDetailDialog(Shell shell, @Nullable String key, String value) {
        super(shell, value.length() > 80 || key != null && key.length() > 80 ? 0x10000010 : 0x10000000);
        this.key = key;
        this.value = value;
        this.setText(JFaceMessages.get(LBL_SYSTEM_INFO_DETAIL_DIALOG_TITLE));
    }

    public PropertyDetailDialog(Shell shell, String item) {
        this(shell, null, item);
    }

    public void open() {
        Shell shell = new Shell(this.getParent(), this.getStyle());
        shell.setText(this.getText());
        shell.setImage(shell.getDisplay().getSystemImage(2));
        this.createContents(shell);
        this.constrainShellSize(shell);
        shell.open();
    }

    protected void adjustTextHeight(Text text, int lines) {
        if (text.getLayoutData() instanceof GridData) {
            GridData gd = (GridData)text.getLayoutData();
            gd.heightHint = text.getLineHeight() * lines;
            gd.widthHint = 0;
        }
    }

    protected void createContents(final Shell shell) {
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)shell);
        if (this.key != null) {
            Label labelKey = new Label((Composite)shell, 0);
            labelKey.setText(JFaceMessages.get(LBL_SYSTEM_INFO_TABLE_KEY));
            GridDataFactory.swtDefaults().applyTo((Control)labelKey);
            Text textKey = new Text((Composite)shell, this.key.length() <= 80 ? 2056 : 2634);
            textKey.setText(this.key);
            textKey.setEditable(false);
            if (Util.isWindows()) {
                textKey.setBackground(shell.getDisplay().getSystemColor(25));
            }
            textKey.addKeyListener((KeyListener)new TextKeyListener(textKey));
            if (this.key.length() <= 80) {
                GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)textKey);
            } else {
                GridDataFactory.swtDefaults().align(4, 4).grab(true, true).applyTo((Control)textKey);
                this.adjustTextHeight(textKey, Math.min(5, 2 + this.key.length() / 80));
            }
        }
        Label labelValue = new Label((Composite)shell, 0);
        labelValue.setText(JFaceMessages.get(LBL_SYSTEM_INFO_TABLE_VALUE));
        GridDataFactory.swtDefaults().applyTo((Control)labelValue);
        Text textValue = new Text((Composite)shell, this.value.length() <= 80 ? 2056 : 2634);
        textValue.setText(this.value);
        textValue.setEditable(false);
        if (Util.isWindows()) {
            textValue.setBackground(shell.getDisplay().getSystemColor(25));
        }
        textValue.addKeyListener((KeyListener)new TextKeyListener(textValue));
        if (this.value.length() <= 80) {
            GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)textValue);
        } else {
            GridDataFactory.swtDefaults().align(4, 4).grab(true, true).applyTo((Control)textValue);
            this.adjustTextHeight(textValue, Math.min(5, 2 + this.value.length() / 80));
        }
        Button closeButton = new Button((Composite)shell, 8);
        closeButton.setText(JFaceMessages.get(LBL_BUTTON_CLOSE));
        int buttonWidth = SwtUtils.convertHorizontalDLUsToPixels((Control)closeButton, 61);
        GridDataFactory.swtDefaults().span(2, 1).align(0x1000000, 0x1000000).grab(true, false).minSize(buttonWidth, -1).applyTo((Control)closeButton);
        closeButton.setFocus();
        closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(@Nullable SelectionEvent se) {
                shell.close();
            }
        });
        shell.setDefaultButton(closeButton);
    }

    protected void constrainShellSize(Shell shell) {
        Point packedSize = this.getMinimumSize(shell);
        Rectangle screen = shell.getMonitor().getClientArea();
        shell.setSize(Math.max(packedSize.x, screen.width / 3), packedSize.y);
        shell.setMinimumSize(shell.getMinimumSize().x, packedSize.y);
    }

    protected Point getMinimumSize(Shell shell) {
        return shell.computeSize(-1, -1, true);
    }

    protected static class TextKeyListener
    extends KeyAdapter {
        private final Text text;

        public TextKeyListener(Text text) {
            this.text = text;
        }

        public void keyPressed(@Nullable KeyEvent e) {
            if (e != null && SWT.MOD1 == e.stateMask) {
                if (99 == e.keyCode) {
                    this.text.copy();
                } else if (97 == e.keyCode) {
                    this.text.selectAll();
                }
            }
        }
    }
}

