/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.sysinfo;

import io.github.albertus82.jface.EnhancedErrorDialog;
import io.github.albertus82.jface.JFaceMessages;
import io.github.albertus82.jface.SwtUtils;
import io.github.albertus82.jface.sysinfo.PropertyDetailDialog;
import io.github.albertus82.jface.sysinfo.SystemInformationExporter;
import io.github.albertus82.jface.sysinfo.SystemInformationGatherer;
import io.github.albertus82.util.MapUtils;
import io.github.albertus82.util.NewLine;
import io.github.albertus82.util.logging.LoggerFactory;
import java.lang.management.ManagementPermission;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class SystemInformationDialog
extends Dialog {
    private static final String LBL_BUTTON_CLOSE = "lbl.button.close";
    private static final String LBL_MENU_ITEM_OPEN = "lbl.menu.item.open";
    private static final String LBL_MENU_ITEM_COPY = "lbl.menu.item.copy";
    private static final String LBL_MENU_ITEM_SELECT_ALL = "lbl.menu.item.select.all";
    private static final String LBL_SYSTEM_INFO_DIALOG_TITLE = "lbl.system.info.dialog.title";
    private static final String LBL_SYSTEM_INFO_NOT_AVAILABLE = "lbl.system.info.notAvailable";
    private static final String LBL_SYSTEM_INFO_TAB_ENV = "lbl.system.info.tab.env";
    private static final String LBL_SYSTEM_INFO_TAB_JVMARGS = "lbl.system.info.tab.jvmArgs";
    private static final String LBL_SYSTEM_INFO_TAB_PROPERTIES = "lbl.system.info.tab.properties";
    private static final String LBL_SYSTEM_INFO_TABLE_KEY = "lbl.system.info.table.key";
    private static final String LBL_SYSTEM_INFO_TABLE_VALUE = "lbl.system.info.table.value";
    private static final String LBL_SYSTEM_INFO_EXPORT_ENV = "lbl.system.info.export.env";
    private static final String LBL_SYSTEM_INFO_EXPORT_JVMARGS = "lbl.system.info.export.jvmArgs";
    private static final String LBL_SYSTEM_INFO_EXPORT_PROPERTIES = "lbl.system.info.export.properties";
    private static final String ERR_SYSTEM_INFO_EXPORT = "err.system.info.export";
    private static final float MONITOR_SIZE_DIVISOR = 1.67f;
    private static final String TABLE_ITEM_FONT_SYMBOLIC_NAME = SystemInformationDialog.class.getName();
    private static final Logger log = LoggerFactory.getLogger(SystemInformationDialog.class);
    @Nullable
    protected final Map<String, String> properties;
    @Nullable
    protected final Map<String, String> env;
    @Nullable
    protected final Iterable<String> jvmArgs;

    public static boolean isAvailable() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return true;
        }
        try {
            sm.checkPropertiesAccess();
            return true;
        }
        catch (SecurityException e) {
            log.log(Level.FINE, "The calling thread does not have permission to access the system properties:", e);
            try {
                sm.checkPermission(new RuntimePermission("getenv.*"));
                return true;
            }
            catch (SecurityException e2) {
                log.log(Level.FINE, "Access to the environment variables is not permitted based on the current security policy:", e2);
                try {
                    sm.checkPermission(new ManagementPermission("monitor"));
                    return true;
                }
                catch (SecurityException e3) {
                    log.log(Level.FINE, "Access to the JVM arguments is not permitted based on the current security policy:", e3);
                    return false;
                }
            }
        }
    }

    public static void open(Shell shell) {
        try {
            shell.setCursor(shell.getDisplay().getSystemCursor(1));
            SystemInformationGatherer gatherer = new SystemInformationGatherer();
            ModalContext.run((IRunnableWithProgress)gatherer, (boolean)true, (IProgressMonitor)new NullProgressMonitor(), (Display)shell.getDisplay());
            if (gatherer.getProperties() != null || gatherer.getEnv() != null || gatherer.getJvmArgs() != null) {
                new SystemInformationDialog(shell, gatherer.getProperties(), gatherer.getEnv(), gatherer.getJvmArgs()).open();
            } else {
                MessageBox box = new MessageBox(shell, 2);
                box.setText(JFaceMessages.get(LBL_SYSTEM_INFO_DIALOG_TITLE));
                box.setMessage(JFaceMessages.get(LBL_SYSTEM_INFO_NOT_AVAILABLE));
                box.open();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            shell.setCursor(null);
        }
    }

    protected SystemInformationDialog(Shell parent, @Nullable Map<String, String> properties, @Nullable Map<String, String> env, @Nullable Iterable<String> jvmArgs) {
        this(parent, 0x10000410, properties, env, jvmArgs);
    }

    protected SystemInformationDialog(Shell parent, int style, @Nullable Map<String, String> properties, @Nullable Map<String, String> env, @Nullable Iterable<String> jvmArgs) {
        super(parent, style);
        this.properties = properties;
        this.env = env;
        this.jvmArgs = jvmArgs;
        this.setText(JFaceMessages.get(LBL_SYSTEM_INFO_DIALOG_TITLE));
    }

    protected void open() {
        Shell shell = new Shell(this.getParent(), this.getStyle());
        shell.setText(this.getText());
        shell.setImage(shell.getDisplay().getSystemImage(2));
        this.createMenuBar(shell);
        this.createContents(shell);
        this.constrainShellSize(shell);
        shell.open();
    }

    protected void createMenuBar(final Shell shell) {
        Menu bar = new Menu((Decorations)shell, 2);
        shell.setMenuBar(bar);
        Menu fileMenu = new Menu((Decorations)shell, 4);
        MenuItem fileMenuHeader = new MenuItem(bar, 64);
        fileMenuHeader.setText(JFaceMessages.get("lbl.menu.item.file"));
        fileMenuHeader.setMenu(fileMenu);
        MenuItem exportMenuItem = new MenuItem(fileMenu, 8);
        exportMenuItem.setText(JFaceMessages.get("lbl.menu.item.export") + SwtUtils.getMod1ShortcutLabel('s'));
        exportMenuItem.setAccelerator(SWT.MOD1 | 0x73);
        exportMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SystemInformationDialog.this.export(shell);
            }
        });
        new MenuItem(fileMenu, 2);
        MenuItem closeMenuItem = new MenuItem(fileMenu, 8);
        closeMenuItem.setText(JFaceMessages.get("lbl.menu.item.close"));
        closeMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                shell.close();
            }
        });
    }

    protected void constrainShellSize(Shell shell) {
        Rectangle screen = shell.getMonitor().getClientArea();
        shell.setSize((int)((float)screen.width / 1.67f), (int)((float)screen.height / 1.67f));
    }

    protected void createContents(Shell shell) {
        GridLayoutFactory.swtDefaults().applyTo((Composite)shell);
        TabFolder folder = new TabFolder((Composite)shell, 0);
        GridLayoutFactory.fillDefaults().applyTo((Composite)folder);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)folder);
        if (this.properties != null) {
            TabItem propertiesTab = new TabItem(folder, 0);
            propertiesTab.setText(JFaceMessages.get(LBL_SYSTEM_INFO_TAB_PROPERTIES));
            Table propertiesTable = this.createTable((Composite)folder, this.properties);
            propertiesTab.setControl((Control)propertiesTable);
        }
        if (this.env != null) {
            TabItem envTab = new TabItem(folder, 0);
            envTab.setText(JFaceMessages.get(LBL_SYSTEM_INFO_TAB_ENV));
            Table envTable = this.createTable((Composite)folder, this.env);
            envTab.setControl((Control)envTable);
        }
        if (this.jvmArgs != null) {
            TabItem jvmArgsTab = new TabItem(folder, 0);
            jvmArgsTab.setText(JFaceMessages.get(LBL_SYSTEM_INFO_TAB_JVMARGS));
            List jvmArgsList = this.createList((Composite)folder, this.jvmArgs);
            jvmArgsTab.setControl((Control)jvmArgsList);
        }
        this.createButtons(shell);
    }

    protected Table createTable(Composite parent, Map<String, String> map) {
        final Table table = new Table(parent, 65538);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)table);
        for (String title : new String[]{JFaceMessages.get(LBL_SYSTEM_INFO_TABLE_KEY), JFaceMessages.get(LBL_SYSTEM_INFO_TABLE_VALUE)}) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(title);
        }
        FontRegistry fontRegistry = JFaceResources.getFontRegistry();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            TableItem item = new TableItem(table, 0);
            if (!fontRegistry.hasValueFor(TABLE_ITEM_FONT_SYMBOLIC_NAME)) {
                fontRegistry.put(TABLE_ITEM_FONT_SYMBOLIC_NAME, item.getFont().getFontData());
            }
            item.setFont(0, fontRegistry.getBold(TABLE_ITEM_FONT_SYMBOLIC_NAME));
            item.setText(new String[]{entry.getKey(), entry.getValue()});
        }
        for (int i = 0; i < table.getColumnCount(); ++i) {
            table.getColumn(i).pack();
        }
        table.pack();
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(@Nullable KeyEvent e) {
                if (e != null && SWT.MOD1 == e.stateMask) {
                    if (99 == e.keyCode) {
                        SystemInformationDialog.this.copy(table);
                    } else if (97 == e.keyCode) {
                        table.selectAll();
                    }
                }
            }
        });
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(@Nullable SelectionEvent e) {
                if (table.getSelectionIndex() != -1) {
                    new PropertyDetailDialog(table.getShell(), table.getItem(table.getSelectionIndex()).getText(0), table.getItem(table.getSelectionIndex()).getText(1)).open();
                }
            }
        });
        this.createTableContextMenu(table);
        return table;
    }

    protected Menu createTableContextMenu(final Table table) {
        final Menu contextMenu = new Menu((Control)table);
        MenuItem openMenuItem = new MenuItem(contextMenu, 8);
        openMenuItem.setText(JFaceMessages.get(LBL_MENU_ITEM_OPEN));
        openMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(@Nullable SelectionEvent e) {
                if (table.getSelectionIndex() != -1) {
                    new PropertyDetailDialog(table.getShell(), table.getItem(table.getSelectionIndex()).getText(0), table.getItem(table.getSelectionIndex()).getText(1)).open();
                }
            }
        });
        contextMenu.setDefaultItem(openMenuItem);
        new MenuItem(contextMenu, 2);
        final MenuItem copyMenuItem = new MenuItem(contextMenu, 8);
        copyMenuItem.setText(JFaceMessages.get(LBL_MENU_ITEM_COPY) + SwtUtils.getMod1ShortcutLabel('c'));
        copyMenuItem.setAccelerator(SWT.MOD1 | 0x63);
        copyMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(@Nullable SelectionEvent e) {
                SystemInformationDialog.this.copy(table);
            }
        });
        new MenuItem(contextMenu, 2);
        final MenuItem selectAllMenuItem = new MenuItem(contextMenu, 8);
        selectAllMenuItem.setText(JFaceMessages.get(LBL_MENU_ITEM_SELECT_ALL) + SwtUtils.getMod1ShortcutLabel('a'));
        selectAllMenuItem.setAccelerator(SWT.MOD1 | 0x61);
        selectAllMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(@Nullable SelectionEvent e) {
                table.selectAll();
            }
        });
        table.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(@Nullable MenuDetectEvent e) {
                copyMenuItem.setEnabled(SystemInformationDialog.this.canCopy(table));
                selectAllMenuItem.setEnabled(table.getItemCount() > 0);
                contextMenu.setVisible(true);
            }
        });
        return contextMenu;
    }

    protected List createList(Composite parent, Iterable<String> jvmArgs) {
        final List list = new List(parent, 770);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)list);
        for (String arg : jvmArgs) {
            list.add(arg);
        }
        list.pack();
        list.addTraverseListener(new TraverseListener(){

            public void keyTraversed(@Nullable TraverseEvent e) {
                if (e != null && 4 == e.detail && list.getSelectionIndex() != -1) {
                    new PropertyDetailDialog(list.getShell(), list.getItem(list.getSelectionIndex())).open();
                }
            }
        });
        list.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(@Nullable KeyEvent e) {
                if (e != null && SWT.MOD1 == e.stateMask) {
                    if (99 == e.keyCode) {
                        SystemInformationDialog.this.copy(list);
                    } else if (97 == e.keyCode) {
                        list.selectAll();
                    }
                }
            }
        });
        list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(@Nullable SelectionEvent e) {
                if (list.getSelectionIndex() != -1) {
                    new PropertyDetailDialog(list.getShell(), list.getItem(list.getSelectionIndex())).open();
                }
            }
        });
        this.createListContextMenu(list);
        return list;
    }

    protected Menu createListContextMenu(final List list) {
        final Menu contextMenu = new Menu((Control)list);
        MenuItem openMenuItem = new MenuItem(contextMenu, 8);
        openMenuItem.setText(JFaceMessages.get(LBL_MENU_ITEM_OPEN));
        openMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(@Nullable SelectionEvent e) {
                if (list.getSelectionIndex() != -1) {
                    new PropertyDetailDialog(list.getShell(), list.getItem(list.getSelectionIndex())).open();
                }
            }
        });
        contextMenu.setDefaultItem(openMenuItem);
        new MenuItem(contextMenu, 2);
        final MenuItem copyMenuItem = new MenuItem(contextMenu, 8);
        copyMenuItem.setText(JFaceMessages.get(LBL_MENU_ITEM_COPY) + SwtUtils.getMod1ShortcutLabel('c'));
        copyMenuItem.setAccelerator(SWT.MOD1 | 0x63);
        copyMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(@Nullable SelectionEvent e) {
                SystemInformationDialog.this.copy(list);
            }
        });
        new MenuItem(contextMenu, 2);
        final MenuItem selectAllMenuItem = new MenuItem(contextMenu, 8);
        selectAllMenuItem.setText(JFaceMessages.get(LBL_MENU_ITEM_SELECT_ALL) + SwtUtils.getMod1ShortcutLabel('a'));
        selectAllMenuItem.setAccelerator(SWT.MOD1 | 0x61);
        selectAllMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(@Nullable SelectionEvent e) {
                list.selectAll();
            }
        });
        list.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(@Nullable MenuDetectEvent e) {
                copyMenuItem.setEnabled(SystemInformationDialog.this.canCopy(list));
                selectAllMenuItem.setEnabled(list.getItemCount() > 0);
                contextMenu.setVisible(true);
            }
        });
        return contextMenu;
    }

    protected Button createButtons(final Shell shell) {
        Button closeButton = new Button((Composite)shell, 8);
        closeButton.setText(JFaceMessages.get(LBL_BUTTON_CLOSE));
        int buttonWidth = SwtUtils.convertHorizontalDLUsToPixels((Control)closeButton, 61);
        GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).grab(true, false).minSize(buttonWidth, -1).applyTo((Control)closeButton);
        closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(@Nullable SelectionEvent e) {
                shell.close();
            }
        });
        return closeButton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copy(Table table) {
        if (this.canCopy(table)) {
            StringBuilder data = new StringBuilder();
            for (int row = 0; row < table.getSelectionCount(); ++row) {
                for (int col = 0; col < table.getColumnCount(); ++col) {
                    data.append(table.getSelection()[row].getText(col));
                    if (col == 0) {
                        data.append('=');
                        continue;
                    }
                    if (row == table.getSelectionCount() - 1) continue;
                    data.append(NewLine.SYSTEM_LINE_SEPARATOR);
                }
            }
            Clipboard clipboard = null;
            try {
                clipboard = new Clipboard(table.getDisplay());
                clipboard.setContents((Object[])new String[]{data.toString()}, (Transfer[])new TextTransfer[]{TextTransfer.getInstance()});
            }
            finally {
                if (clipboard != null) {
                    clipboard.dispose();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copy(List list) {
        if (this.canCopy(list)) {
            StringBuilder data = new StringBuilder();
            for (int row = 0; row < list.getSelectionCount(); ++row) {
                data.append(list.getSelection()[row]);
                if (row == list.getSelectionCount() - 1) continue;
                data.append(NewLine.SYSTEM_LINE_SEPARATOR);
            }
            Clipboard clipboard = null;
            try {
                clipboard = new Clipboard(list.getDisplay());
                clipboard.setContents((Object[])new String[]{data.toString()}, (Transfer[])new TextTransfer[]{TextTransfer.getInstance()});
            }
            finally {
                if (clipboard != null) {
                    clipboard.dispose();
                }
            }
        }
    }

    protected boolean canCopy(Table table) {
        return !table.isDisposed() && table.getColumnCount() > 0 && table.getSelectionCount() > 0;
    }

    protected boolean canCopy(List list) {
        return !list.isDisposed() && list.getSelectionCount() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void export(Shell shell) {
        String fileName = this.openSaveDialog(shell);
        if (fileName != null && !fileName.trim().isEmpty()) {
            try {
                SwtUtils.blockShell(shell);
                LinkedHashMap<String, Map<String, String>> maps = MapUtils.newLinkedHashMapWithExpectedSize(2);
                maps.put(JFaceMessages.get(LBL_SYSTEM_INFO_EXPORT_PROPERTIES), this.properties);
                maps.put(JFaceMessages.get(LBL_SYSTEM_INFO_EXPORT_ENV), this.env);
                SystemInformationExporter exporter = new SystemInformationExporter(fileName, maps, Collections.singletonMap(JFaceMessages.get(LBL_SYSTEM_INFO_EXPORT_JVMARGS), this.jvmArgs));
                ModalContext.run((IRunnableWithProgress)exporter, (boolean)true, (IProgressMonitor)new NullProgressMonitor(), (Display)shell.getDisplay());
            }
            catch (InvocationTargetException e) {
                String message = JFaceMessages.get(ERR_SYSTEM_INFO_EXPORT);
                log.log(Level.WARNING, message, e);
                SwtUtils.unblockShell(shell);
                EnhancedErrorDialog.openError(shell, JFaceMessages.get(LBL_SYSTEM_INFO_DIALOG_TITLE), message, 2, e.getCause() != null ? e.getCause() : e, shell.getDisplay().getSystemImage(8));
            }
            catch (Exception e) {
                String message = JFaceMessages.get(ERR_SYSTEM_INFO_EXPORT);
                log.log(Level.SEVERE, message, e);
                SwtUtils.unblockShell(shell);
                EnhancedErrorDialog.openError(shell, JFaceMessages.get(LBL_SYSTEM_INFO_DIALOG_TITLE), message, 4, e, shell.getDisplay().getSystemImage(1));
            }
            finally {
                SwtUtils.unblockShell(shell);
            }
        }
    }

    protected String openSaveDialog(Shell parent) {
        FileDialog saveDialog = new FileDialog(parent, 8192);
        saveDialog.setFilterExtensions(new String[]{"*.TXT;*.txt"});
        saveDialog.setFileName("sysinfo.txt");
        saveDialog.setOverwrite(true);
        return saveDialog.open();
    }
}

