/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.sysinfo;

import io.github.albertus82.jface.JFaceMessages;
import io.github.albertus82.util.IOUtils;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class SystemInformationExporter
implements IRunnableWithProgress {
    private static final String TASK_NAME = "Exporting system information";
    private static final String LBL_SYSTEM_INFO_EXPORT_TITLE = "lbl.system.info.export.title";
    private static final char KEY_VALUE_SEPARATOR = '=';
    private final String fileName;
    private final Map<String, Map<String, String>> maps;
    private final Map<String, Iterable<String>> iterables;

    public SystemInformationExporter(String fileName, Map<String, Map<String, String>> maps, Map<String, Iterable<String>> iterables) {
        this.fileName = fileName;
        this.maps = maps;
        this.iterables = iterables;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        monitor.beginTask(TASK_NAME, this.maps.size() + this.iterables.size());
        FileWriter fw = null;
        BufferedWriter bw = null;
        try {
            fw = new FileWriter(this.fileName);
            bw = new BufferedWriter(fw);
            bw.write(JFaceMessages.get(LBL_SYSTEM_INFO_EXPORT_TITLE, DateFormat.getDateTimeInstance(0, 0, new Locale(JFaceMessages.getLanguage())).format(new Date())));
            bw.newLine();
            for (Map.Entry<String, Map<String, String>> entry : this.maps.entrySet()) {
                bw.newLine();
                bw.write(entry.getKey());
                bw.newLine();
                for (Map.Entry<String, String> e2 : entry.getValue().entrySet()) {
                    bw.append(e2.getKey()).append('=').append(e2.getValue());
                    bw.newLine();
                }
                monitor.worked(1);
            }
            for (Map.Entry<String, Object> entry : this.iterables.entrySet()) {
                bw.newLine();
                bw.write(entry.getKey());
                bw.newLine();
                for (String str : (Iterable)entry.getValue()) {
                    bw.write(str);
                    bw.newLine();
                }
                monitor.worked(1);
            }
        }
        catch (IOException e) {
            try {
                throw new InvocationTargetException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bw, fw);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(bw, fw);
        monitor.done();
    }
}

