/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.sysinfo;

import io.github.albertus82.util.logging.LoggerFactory;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class SystemInformationGatherer
implements IRunnableWithProgress {
    private static final String TASK_NAME = "Gathering system information";
    private static final Logger log = LoggerFactory.getLogger(SystemInformationGatherer.class);
    @Nullable
    private Map<String, String> properties;
    @Nullable
    private Map<String, String> env;
    @Nullable
    private List<String> jvmArgs;

    public void run(IProgressMonitor monitor) {
        monitor.beginTask(TASK_NAME, 3);
        try {
            Properties systemProperties = System.getProperties();
            this.properties = new TreeMap<String, String>();
            for (Map.Entry<Object, Object> entry : systemProperties.entrySet()) {
                if (entry == null) continue;
                this.properties.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
            }
        }
        catch (SecurityException e) {
            log.log(Level.FINE, "The calling thread does not have permission to access the system properties:", e);
        }
        monitor.worked(1);
        try {
            Map<String, String> systemEnv = System.getenv();
            this.env = new TreeMap<String, String>();
            for (Map.Entry<Object, Object> entry : systemEnv.entrySet()) {
                if (entry == null) continue;
                this.env.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
            }
        }
        catch (SecurityException e) {
            log.log(Level.FINE, "Access to the environment variables is not permitted based on the current security policy:", e);
        }
        monitor.worked(1);
        try {
            this.jvmArgs = Collections.unmodifiableList(ManagementFactory.getRuntimeMXBean().getInputArguments());
        }
        catch (SecurityException e) {
            log.log(Level.FINE, "Access to the JVM arguments is not permitted based on the current security policy:", e);
        }
        monitor.done();
    }

    @Nullable
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Nullable
    public Map<String, String> getEnv() {
        return this.env;
    }

    @Nullable
    public List<String> getJvmArgs() {
        return this.jvmArgs;
    }
}

