/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.validation;

import io.github.albertus82.jface.validation.StringTextValidator;
import io.github.albertus82.util.logging.LoggerFactory;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Text;

public class DateTextValidator
extends StringTextValidator {
    private static final Logger log = LoggerFactory.getLogger(DateTextValidator.class);
    private static final boolean EMPTY_STRING_ALLOWED = true;
    protected final ThreadLocal<DateFormat> dateFormat = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat df = new SimpleDateFormat(DateTextValidator.this.pattern);
            df.setLenient(false);
            return df;
        }
    };
    private final String pattern;
    private Date minValidValue;
    private Date maxValidValue;

    public DateTextValidator(Text text, String pattern) {
        this(text, pattern, true);
    }

    public DateTextValidator(Text text, String pattern, boolean emptyStringAllowed) {
        super(text, emptyStringAllowed);
        this.pattern = pattern;
    }

    public DateTextValidator(Text text, String pattern, boolean emptyStringAllowed, Date minValidValue, Date maxValidValue) {
        this(text, pattern, emptyStringAllowed);
        this.minValidValue = minValidValue;
        this.maxValidValue = maxValidValue;
    }

    @Override
    public boolean isValid() {
        String value = ((Text)this.getControl()).getText();
        if (this.isEmptyStringAllowed() && value.isEmpty()) {
            return true;
        }
        try {
            Date date = this.dateFormat.get().parse(value);
            if (!(this.getMinValidValue() != null && date.before(this.getMinValidValue()) || this.getMaxValidValue() != null && date.after(this.getMaxValidValue()))) {
                return true;
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, "An error occurred while validating the date:", e);
        }
        return false;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Date getMinValidValue() {
        return this.minValidValue;
    }

    public void setMinValidValue(Date minValidValue) {
        this.minValidValue = minValidValue;
    }

    public Date getMaxValidValue() {
        return this.maxValidValue;
    }

    public void setMaxValidValue(Date maxValidValue) {
        this.maxValidValue = maxValidValue;
    }
}

