/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.validation;

import io.github.albertus82.jface.validation.StringTextValidator;
import io.github.albertus82.util.logging.LoggerFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Text;

public abstract class NumberTextValidator<T extends Number>
extends StringTextValidator {
    private static final Logger log = LoggerFactory.getLogger(NumberTextValidator.class);
    private static final boolean EMPTY_STRING_ALLOWED = false;
    private T minValidValue;
    private T maxValidValue;

    protected NumberTextValidator(Text text) {
        super(text, false);
    }

    protected NumberTextValidator(Text text, boolean emptyStringAllowed) {
        super(text, emptyStringAllowed);
    }

    protected NumberTextValidator(Text text, boolean emptyStringAllowed, T minValidValue, T maxValidValue) {
        this(text, emptyStringAllowed);
        this.minValidValue = minValidValue;
        this.maxValidValue = maxValidValue;
    }

    protected abstract Comparable<T> toNumber(String var1);

    @Override
    public boolean isValid() {
        String value = ((Text)this.getControl()).getText();
        if (this.isEmptyStringAllowed() && value.isEmpty()) {
            return true;
        }
        try {
            Comparable<T> number = this.toNumber(value);
            if (!(this.getMinValidValue() != null && number.compareTo(this.getMinValidValue()) < 0 || this.getMaxValidValue() != null && number.compareTo(this.getMaxValidValue()) > 0)) {
                return true;
            }
        }
        catch (RuntimeException e) {
            log.log(Level.FINE, "An error occurred while validating the number:", e);
        }
        return false;
    }

    public T getMinValidValue() {
        return this.minValidValue;
    }

    public void setMinValidValue(T minValidValue) {
        this.minValidValue = minValidValue;
    }

    public T getMaxValidValue() {
        return this.maxValidValue;
    }

    public void setMaxValidValue(T maxValidValue) {
        this.maxValidValue = maxValidValue;
    }
}

