/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.net;

import io.github.albertus82.util.IOUtils;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.Locale;
import javax.activation.FileTypeMap;
import javax.activation.MimetypesFileTypeMap;
import javax.annotation.Nullable;

public class MimeTypesMap {
    private static final String MIME_TYPES_RESOURCE_NAME = "mime.types";
    @Nullable
    private static MimeTypesMap instance;
    private final FileTypeMap map;

    public static synchronized MimeTypesMap getInstance() {
        if (instance == null) {
            instance = new MimeTypesMap();
        }
        return instance;
    }

    private MimeTypesMap() {
        InputStream is = null;
        try {
            is = this.getClass().getResourceAsStream(MIME_TYPES_RESOURCE_NAME);
            this.map = is != null ? new MimetypesFileTypeMap(is) : new MimetypesFileTypeMap();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)is);
    }

    public String getContentType(File f) {
        return this.getContentType(f.getName());
    }

    public String getContentType(String filename) {
        return this.map.getContentType(filename.trim().toLowerCase(Locale.ROOT));
    }
}

