/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.net.httpserver;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import io.github.albertus82.jface.JFaceMessages;
import io.github.albertus82.net.MimeTypesMap;
import io.github.albertus82.net.httpserver.HttpDateGenerator;
import io.github.albertus82.net.httpserver.HttpException;
import io.github.albertus82.net.httpserver.HttpPathHandler;
import io.github.albertus82.net.httpserver.HttpStatusCodes;
import io.github.albertus82.net.httpserver.annotation.Path;
import io.github.albertus82.net.httpserver.config.IHttpServerConfig;
import io.github.albertus82.util.ClasspathResourceUtils;
import io.github.albertus82.util.DigestOutputStream;
import io.github.albertus82.util.IOUtils;
import io.github.albertus82.util.NewLine;
import io.github.albertus82.util.Resource;
import io.github.albertus82.util.StringUtils;
import io.github.albertus82.util.logging.LoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.xml.bind.DatatypeConverter;

public abstract class BaseHttpHandler
implements HttpPathHandler {
    private static final String HEADER_KEY_IF_NONE_MATCH = "If-None-Match";
    private static final String[] maskedHeaderKeys = new String[]{"authorization", "password", "session", "token"};
    private static final Logger log = LoggerFactory.getLogger(BaseHttpHandler.class);
    private static Collection<Resource> resources;
    private static final Charset charset;
    public static final String PREFERRED_CHARSET = "UTF-8";
    protected static final int BUFFER_SIZE = 8192;
    private static final String MSG_HTTPSERVER_BAD_METHOD = "msg.httpserver.bad.method";
    private static Object[] lastRequestInfo;
    private static Object[] lastResponseInfo;
    private final IHttpServerConfig httpServerConfig;
    private boolean enabled = true;
    private String path;

    private static Collection<Resource> initResources() {
        List<Resource> resources = ClasspathResourceUtils.getResourceList(Pattern.compile(".*(?<!\\.class)$"));
        log.log(Level.CONFIG, JFaceMessages.get("msg.httpserver.resources.found"), Integer.toString(resources.size()));
        if (log.isLoggable(Level.FINE)) {
            for (Resource resource : resources) {
                log.fine(String.valueOf(resource));
            }
        }
        return resources;
    }

    protected BaseHttpHandler(IHttpServerConfig config) {
        this.httpServerConfig = config;
    }

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        this.logRequest(exchange);
        try {
            if (this.httpServerConfig.isEnabled() && this.isEnabled(exchange)) {
                this.service(exchange);
            } else {
                this.sendForbidden(exchange);
            }
        }
        catch (HttpException e) {
            log.log(Level.INFO, e.toString() + " -- " + JFaceMessages.get("msg.httpserver.request.headers", this.buildSafeHeadersMap(exchange.getRequestHeaders())), e);
            this.sendError(exchange, e);
        }
        catch (IOException e) {
            log.log(Level.FINE, "Broken pipe:", e);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.toString() + " -- " + JFaceMessages.get("msg.httpserver.request.headers", this.buildSafeHeadersMap(exchange.getRequestHeaders())), e);
            this.sendInternalError(exchange);
        }
        finally {
            exchange.close();
            this.logResponse(exchange);
        }
    }

    protected Map<String, Object> buildSafeHeadersMap(Headers headers) {
        TreeMap<String, Object> headersToLog = new TreeMap<String, Object>();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String key = entry.getKey();
            if (key == null) continue;
            String lowerCaseKey = key.toLowerCase(Locale.ROOT);
            for (String maskedHeaderKey : maskedHeaderKeys) {
                if (!lowerCaseKey.contains(maskedHeaderKey)) continue;
                headersToLog.put(key, "****");
                break;
            }
            if (headersToLog.containsKey(key)) continue;
            headersToLog.put(key, entry.getValue());
        }
        return headersToLog;
    }

    protected void service(HttpExchange exchange) throws IOException {
        String method = exchange.getRequestMethod();
        if ("get".equalsIgnoreCase(method)) {
            this.doGet(exchange);
        } else if ("post".equalsIgnoreCase(method)) {
            this.doPost(exchange);
        } else if ("put".equalsIgnoreCase(method)) {
            this.doPut(exchange);
        } else if ("patch".equalsIgnoreCase(method)) {
            this.doPatch(exchange);
        } else if ("delete".equalsIgnoreCase(method)) {
            this.doDelete(exchange);
        } else if ("head".equalsIgnoreCase(method)) {
            this.doHead(exchange);
        } else if ("trace".equalsIgnoreCase(method) && this.httpServerConfig.isTraceMethodEnabled()) {
            this.doTrace(exchange);
        } else if ("options".equalsIgnoreCase(method)) {
            this.doOptions(exchange);
        } else {
            throw new HttpException(405, JFaceMessages.get(MSG_HTTPSERVER_BAD_METHOD));
        }
    }

    protected void sendForbidden(HttpExchange exchange) throws IOException {
        this.sendResponse(exchange, 403);
    }

    protected void sendInternalError(HttpExchange exchange) throws IOException {
        this.sendResponse(exchange, 500);
    }

    protected void sendError(HttpExchange exchange, HttpException e) throws IOException {
        this.sendResponse(exchange, e.getStatusCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doHead(HttpExchange exchange) throws IOException {
        OutputStream out = exchange.getResponseBody();
        OutputStream dummy = new OutputStream(){

            @Override
            public void write(int b) {
            }
        };
        exchange.setStreams(null, dummy);
        try {
            this.doGet(exchange);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                log.log(Level.FINE, "An error occurred while closing the response:", e);
            }
        }
    }

    protected void doTrace(HttpExchange exchange) throws IOException {
        StringBuilder responseString = new StringBuilder("trace".toUpperCase()).append(' ').append(exchange.getRequestURI()).append(' ').append(exchange.getProtocol());
        for (String headerName : exchange.getRequestHeaders().keySet()) {
            responseString.append((Object)NewLine.CRLF).append(headerName).append(": ").append(exchange.getRequestHeaders().getFirst(headerName));
        }
        responseString.append((Object)NewLine.CRLF);
        this.setContentTypeHeader(exchange, "message/http");
        exchange.sendResponseHeaders(200, responseString.length());
        OutputStream out = exchange.getResponseBody();
        out.write(responseString.toString().getBytes(this.getCharset()));
        out.close();
    }

    protected void doOptions(HttpExchange exchange) throws IOException {
        TreeSet<String> allowedMethods = new TreeSet<String>();
        if (this.httpServerConfig.isTraceMethodEnabled()) {
            allowedMethods.add("trace".toUpperCase());
        }
        allowedMethods.add("options".toUpperCase());
        for (Method m : this.getAllDeclaredMethods(this.getClass())) {
            if ("doGet".equals(m.getName())) {
                allowedMethods.add("get".toUpperCase());
                allowedMethods.add("head".toUpperCase());
            }
            if ("doPost".equals(m.getName())) {
                allowedMethods.add("post".toUpperCase());
            }
            if ("doPut".equals(m.getName())) {
                allowedMethods.add("put".toUpperCase());
            }
            if (!"doDelete".equals(m.getName())) continue;
            allowedMethods.add("delete".toUpperCase());
        }
        StringBuilder allow = new StringBuilder();
        for (String allowedMethod : allowedMethods) {
            if (allow.length() != 0) {
                allow.append(", ");
            }
            allow.append(allowedMethod);
        }
        exchange.getResponseHeaders().set("Allow", allow.toString());
        exchange.sendResponseHeaders(200, -1L);
    }

    protected void doGet(HttpExchange exchange) throws IOException {
        throw new HttpException(405, JFaceMessages.get(MSG_HTTPSERVER_BAD_METHOD));
    }

    protected void doPost(HttpExchange exchange) throws IOException {
        throw new HttpException(405, JFaceMessages.get(MSG_HTTPSERVER_BAD_METHOD));
    }

    protected void doPut(HttpExchange exchange) throws IOException {
        throw new HttpException(405, JFaceMessages.get(MSG_HTTPSERVER_BAD_METHOD));
    }

    protected void doPatch(HttpExchange exchange) throws IOException {
        throw new HttpException(405, JFaceMessages.get(MSG_HTTPSERVER_BAD_METHOD));
    }

    protected void doDelete(HttpExchange exchange) throws IOException {
        throw new HttpException(405, JFaceMessages.get(MSG_HTTPSERVER_BAD_METHOD));
    }

    private Method[] getAllDeclaredMethods(Class<?> c) {
        if (c.equals(BaseHttpHandler.class)) {
            return new Method[0];
        }
        Method[] parentMethods = this.getAllDeclaredMethods(c.getSuperclass());
        Method[] thisMethods = c.getDeclaredMethods();
        if (parentMethods.length > 0) {
            Method[] allMethods = new Method[parentMethods.length + thisMethods.length];
            System.arraycopy(parentMethods, 0, allMethods, 0, parentMethods.length);
            System.arraycopy(thisMethods, 0, allMethods, parentMethods.length, thisMethods.length);
            thisMethods = allMethods;
        }
        return thisMethods;
    }

    protected void setContentTypeHeader(HttpExchange exchange) {
        this.setContentTypeHeader(exchange, MimeTypesMap.getInstance().getContentType(exchange.getRequestURI().getPath()));
    }

    protected final void setContentTypeHeader(HttpExchange exchange, String value) {
        if (value != null && !value.isEmpty()) {
            exchange.getResponseHeaders().set("Content-Type", value);
        } else {
            exchange.getResponseHeaders().remove("Content-Type");
        }
    }

    protected void setContentLanguageHeader(HttpExchange exchange) {
    }

    protected final void setContentLanguageHeader(HttpExchange exchange, String value) {
        if (value != null && !value.isEmpty()) {
            exchange.getResponseHeaders().set("Content-Language", value);
        } else {
            exchange.getResponseHeaders().remove("Content-Language");
        }
    }

    protected void setGzipHeader(HttpExchange exchange) {
        exchange.getResponseHeaders().set("Content-Encoding", "gzip");
    }

    protected void setEtagHeader(HttpExchange exchange, String eTag) {
        if (eTag != null && ("get".equalsIgnoreCase(exchange.getRequestMethod()) || "head".equalsIgnoreCase(exchange.getRequestMethod()))) {
            exchange.getResponseHeaders().set("ETag", eTag);
        } else {
            exchange.getResponseHeaders().remove("ETag");
        }
    }

    protected void setLastModifiedHeader(HttpExchange exchange, Date lastModified) {
        if (lastModified != null && ("get".equalsIgnoreCase(exchange.getRequestMethod()) || "head".equalsIgnoreCase(exchange.getRequestMethod()))) {
            exchange.getResponseHeaders().set("Last-Modified", new HttpDateGenerator().format(lastModified));
        } else {
            exchange.getResponseHeaders().remove("Last-Modified");
        }
    }

    protected void setRefreshHeader(HttpExchange exchange, Integer seconds) {
        if (seconds != null) {
            exchange.getResponseHeaders().set("Refresh", seconds.toString());
        } else {
            exchange.getResponseHeaders().remove("Refresh");
        }
    }

    protected boolean canCompressResponse(HttpExchange exchange) {
        Object headerRows;
        if (this.httpServerConfig.isCompressionEnabled() && (headerRows = exchange.getRequestHeaders().get("Accept-Encoding")) != null) {
            Iterator iterator = headerRows.iterator();
            while (iterator.hasNext()) {
                String headerRow = (String)iterator.next();
                if (headerRow == null) continue;
                for (String headerValue : headerRow.split(",")) {
                    if (!"gzip".equalsIgnoreCase(headerValue.trim())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected byte[] compressResponse(byte[] uncompressed, HttpExchange exchange) {
        if (this.canCompressResponse(exchange)) {
            try {
                return this.doCompressResponse(uncompressed, exchange);
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Cannot compress response:", e);
            }
        }
        return uncompressed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] doCompressResponse(byte[] uncompressed, HttpExchange exchange) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(uncompressed.length / 4);
        GZIPOutputStream gzos = null;
        try {
            gzos = new GZIPOutputStream(baos);
            gzos.write(uncompressed);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(gzos, baos);
            throw throwable;
        }
        IOUtils.closeQuietly(gzos, baos);
        byte[] compressed = baos.toByteArray();
        if (compressed.length < uncompressed.length) {
            this.setGzipHeader(exchange);
            return compressed;
        }
        return uncompressed;
    }

    protected String generateEtag(byte[] payload) {
        return '\"' + DatatypeConverter.printHexBinary((byte[])BaseHttpHandler.newMd5Digest().digest(payload)).toLowerCase(Locale.ROOT) + '\"';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String generateEtag(File file) throws IOException {
        String string;
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            string = this.generateEtag(is);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)is);
        return string;
    }

    protected String generateEtag(InputStream inputStream) throws IOException {
        DigestOutputStream os = new DigestOutputStream(BaseHttpHandler.newMd5Digest());
        try {
            IOUtils.copy(inputStream, (OutputStream)os, 8192);
        }
        finally {
            IOUtils.closeQuietly((Closeable)os);
        }
        return '\"' + ((Object)os).toString() + '\"';
    }

    protected String generateContentMd5(byte[] responseBody) {
        return DatatypeConverter.printBase64Binary((byte[])BaseHttpHandler.newMd5Digest().digest(responseBody));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String generateContentMd5(File file) throws IOException {
        FileInputStream is = null;
        DigestOutputStream os = new DigestOutputStream(BaseHttpHandler.newMd5Digest());
        try {
            is = new FileInputStream(file);
            IOUtils.copy((InputStream)is, (OutputStream)os, 8192);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(os, is);
            throw throwable;
        }
        IOUtils.closeQuietly(os, is);
        return DatatypeConverter.printBase64Binary((byte[])os.getValue());
    }

    protected void setContentMd5Header(HttpExchange exchange, File file) {
        String headerName = "Content-MD5";
        try {
            exchange.getResponseHeaders().set("Content-MD5", this.generateContentMd5(file));
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Cannot set Content-MD5 header:", e);
        }
    }

    protected void setContentMd5Header(HttpExchange exchange, byte[] responseBody) {
        String headerName = "Content-MD5";
        try {
            exchange.getResponseHeaders().set("Content-MD5", this.generateContentMd5(responseBody));
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Cannot set Content-MD5 header:", e);
        }
    }

    protected void sendResponse(HttpExchange exchange, int statusCode) throws IOException {
        this.sendResponse(exchange, null, statusCode);
    }

    protected void setStatusHeader(HttpExchange exchange, int statusCode) {
        String description = HttpStatusCodes.getMap().get(statusCode);
        if (description != null) {
            exchange.getResponseHeaders().set("Status", statusCode + " " + description);
        }
    }

    protected void sendResponse(HttpExchange exchange, byte[] payload, int statusCode) throws IOException {
        String currentEtag;
        String method = exchange.getRequestMethod();
        if (payload != null && statusCode >= 200 && statusCode < 300 && ("get".equalsIgnoreCase(method) || "head".equalsIgnoreCase(method))) {
            currentEtag = this.generateEtag(payload);
            this.setEtagHeader(exchange, currentEtag);
        } else {
            currentEtag = null;
        }
        String ifNoneMatch = exchange.getRequestHeaders().getFirst(HEADER_KEY_IF_NONE_MATCH);
        if (ifNoneMatch != null && currentEtag != null && currentEtag.equals(ifNoneMatch)) {
            this.setStatusHeader(exchange, 304);
            this.setContentDispositionHeader(exchange, null);
            exchange.sendResponseHeaders(304, -1L);
        } else {
            this.setStatusHeader(exchange, statusCode);
            if (payload != null) {
                this.setContentTypeHeader(exchange);
                this.setContentLanguageHeader(exchange);
                byte[] response = this.compressResponse(payload, exchange);
                if ("head".equalsIgnoreCase(method)) {
                    exchange.getResponseHeaders().set("Content-Length", Integer.toString(response.length));
                    exchange.sendResponseHeaders(statusCode, -1L);
                } else {
                    exchange.sendResponseHeaders(statusCode, response.length);
                    exchange.getResponseBody().write(response);
                }
            } else {
                exchange.sendResponseHeaders(statusCode, -1L);
            }
        }
        exchange.getResponseBody().close();
    }

    protected Resource getStaticResource(String resourcePath) {
        for (Resource resource : BaseHttpHandler.getResources()) {
            if (!('/' + resource.getName().replace(File.separatorChar, '/')).endsWith(resourcePath)) continue;
            return resource;
        }
        return null;
    }

    protected String getPathInfo(HttpExchange exchange) {
        return StringUtils.substringBefore(StringUtils.substringAfter(exchange.getRequestURI().getPath(), this.getPath()), "?");
    }

    protected void sendStaticResource(HttpExchange exchange, String resourcePath, boolean attachment, String cacheControl) throws IOException {
        Resource resource;
        if (!resourcePath.startsWith("/")) {
            resourcePath = '/' + resourcePath;
        }
        if ((resource = this.getStaticResource(resourcePath)) != null) {
            this.doSendStaticResource(exchange, resourcePath, resource, attachment, cacheControl);
        } else {
            this.sendNotFound(exchange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSendStaticResource(HttpExchange exchange, String resourcePath, Resource resource, boolean attachment, String cacheControl) throws IOException {
        InputStream inputStream;
        block11: {
            String method = exchange.getRequestMethod();
            String fileName = new File(resource.getName()).getName();
            long fileSize = resource.getSize();
            inputStream = null;
            try {
                OutputStream output;
                block12: {
                    String currentEtag;
                    if (fileSize >= 0L && fileSize < (long)this.httpServerConfig.getResponseBufferLimit()) {
                        inputStream = this.getClass().getResourceAsStream(resourcePath);
                        if (inputStream == null) {
                            throw new IllegalStateException(resourcePath);
                        }
                        this.sendStaticInMemoryResponse(exchange, inputStream, attachment ? fileName : null, cacheControl);
                        break block11;
                    }
                    if ("get".equalsIgnoreCase(method) || "head".equalsIgnoreCase(method)) {
                        inputStream = this.getClass().getResourceAsStream(resourcePath);
                        if (inputStream == null) {
                            throw new IllegalStateException(resourcePath);
                        }
                        currentEtag = this.generateEtag(inputStream);
                        IOUtils.closeQuietly((Closeable)inputStream);
                        this.setEtagHeader(exchange, currentEtag);
                    } else {
                        currentEtag = null;
                    }
                    String ifNoneMatch = exchange.getRequestHeaders().getFirst(HEADER_KEY_IF_NONE_MATCH);
                    if (ifNoneMatch != null && currentEtag != null && currentEtag.equals(ifNoneMatch)) {
                        this.sendStaticNotModifiedResponse(exchange, cacheControl);
                        break block11;
                    }
                    this.setStaticHeaders(exchange, attachment ? fileName : null, cacheControl);
                    output = null;
                    try {
                        output = this.prepareStaticOutputStream(exchange, fileSize);
                        if ("head".equalsIgnoreCase(exchange.getRequestMethod())) break block12;
                        inputStream = this.getClass().getResourceAsStream(resourcePath);
                        if (inputStream == null) {
                            throw new IllegalStateException(resourcePath);
                        }
                        IOUtils.copy(inputStream, output, 8192);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(output);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Closeable)output);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)inputStream);
    }

    private void sendStaticInMemoryResponse(HttpExchange exchange, InputStream inputStream, String fileName, String cacheControl) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        IOUtils.copy(inputStream, (OutputStream)outputStream, 8192);
        IOUtils.closeQuietly((Closeable)inputStream);
        this.setCacheControlHeader(exchange, cacheControl);
        if (fileName != null) {
            this.setContentDispositionHeader(exchange, "attachment; filename=\"" + fileName + "\"");
        }
        this.sendResponse(exchange, outputStream.toByteArray());
    }

    private OutputStream prepareStaticOutputStream(HttpExchange exchange, long fileSize) throws IOException {
        OutputStream output = null;
        if (this.canCompressResponse(exchange)) {
            this.setGzipHeader(exchange);
            exchange.sendResponseHeaders(200, 0L);
            if (!"head".equalsIgnoreCase(exchange.getRequestMethod())) {
                output = new GZIPOutputStream(exchange.getResponseBody(), 8192);
            }
        } else if (!"head".equalsIgnoreCase(exchange.getRequestMethod())) {
            exchange.sendResponseHeaders(200, fileSize);
            output = exchange.getResponseBody();
        } else {
            exchange.getResponseHeaders().set("Content-Length", Long.toString(fileSize));
            exchange.sendResponseHeaders(200, -1L);
        }
        return output;
    }

    protected void sendStaticFile(HttpExchange exchange, String basePath, String pathInfo, boolean attachment, String cacheControl) throws IOException {
        File file = new File(basePath + pathInfo);
        if (file.getCanonicalPath().startsWith(new File(basePath).getCanonicalPath())) {
            this.doSendStaticFile(exchange, file, attachment, cacheControl);
        } else {
            this.sendNotFound(exchange);
            log.log(Level.WARNING, JFaceMessages.get("err.httpserver.traversal", file, exchange.getRemoteAddress()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSendStaticFile(HttpExchange exchange, File file, boolean attachment, String cacheControl) throws IOException {
        FileInputStream inputStream;
        block10: {
            String method = exchange.getRequestMethod();
            String fileName = file.getName();
            long fileSize = file.length();
            inputStream = null;
            try {
                OutputStream output;
                block11: {
                    String currentEtag;
                    if (fileSize >= 0L && fileSize < (long)this.httpServerConfig.getResponseBufferLimit()) {
                        inputStream = new FileInputStream(file);
                        this.sendStaticInMemoryResponse(exchange, inputStream, attachment ? fileName : null, cacheControl);
                        break block10;
                    }
                    if ("get".equalsIgnoreCase(method) || "head".equalsIgnoreCase(method)) {
                        inputStream = new FileInputStream(file);
                        currentEtag = this.generateEtag(inputStream);
                        IOUtils.closeQuietly((Closeable)inputStream);
                        this.setEtagHeader(exchange, currentEtag);
                    } else {
                        currentEtag = null;
                    }
                    String ifNoneMatch = exchange.getRequestHeaders().getFirst(HEADER_KEY_IF_NONE_MATCH);
                    if (ifNoneMatch != null && currentEtag != null && currentEtag.equals(ifNoneMatch)) {
                        this.sendStaticNotModifiedResponse(exchange, cacheControl);
                        break block10;
                    }
                    this.setStaticHeaders(exchange, attachment ? fileName : null, cacheControl);
                    output = null;
                    try {
                        output = this.prepareStaticOutputStream(exchange, fileSize);
                        if ("head".equalsIgnoreCase(method)) break block11;
                        inputStream = new FileInputStream(file);
                        IOUtils.copy((InputStream)inputStream, output, 8192);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(output);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Closeable)output);
            }
            catch (FileNotFoundException e) {
                try {
                    log.log(Level.FINE, "File not found, sending HTTP 404:", e);
                    this.sendNotFound(exchange);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)inputStream);
            }
        }
        IOUtils.closeQuietly((Closeable)inputStream);
    }

    private void sendStaticNotModifiedResponse(HttpExchange exchange, String cacheControl) throws IOException {
        this.setStatusHeader(exchange, 304);
        this.setCacheControlHeader(exchange, cacheControl);
        this.setContentDispositionHeader(exchange, null);
        exchange.sendResponseHeaders(304, -1L);
    }

    private void setStaticHeaders(HttpExchange exchange, String fileName, String cacheControl) {
        this.setContentTypeHeader(exchange);
        this.setContentLanguageHeader(exchange);
        this.setCacheControlHeader(exchange, cacheControl);
        this.setStatusHeader(exchange, 200);
        if (fileName != null) {
            this.setContentDispositionHeader(exchange, "attachment; filename=\"" + fileName + "\"");
        }
    }

    protected final void setContentDispositionHeader(HttpExchange exchange, String value) {
        if (value != null && !value.isEmpty()) {
            exchange.getResponseHeaders().set("Content-Disposition", value);
        } else {
            exchange.getResponseHeaders().remove("Content-Disposition");
        }
    }

    protected void setCacheControlHeader(HttpExchange exchange, String value) {
        if (value != null && !value.isEmpty()) {
            exchange.getResponseHeaders().set("Cache-Control", value);
        } else {
            exchange.getResponseHeaders().remove("Cache-Control");
        }
    }

    protected void sendNotFound(HttpExchange exchange) throws IOException {
        this.sendResponse(exchange, 404);
    }

    protected void sendResponse(HttpExchange exchange, byte[] payload) throws IOException {
        this.sendResponse(exchange, payload, 200);
    }

    protected void logRequest(HttpExchange exchange) {
        Level level = Level.OFF;
        try {
            level = Level.parse(this.httpServerConfig.getRequestLoggingLevel());
        }
        catch (RuntimeException e) {
            log.log(Level.WARNING, "Cannot log request:", e);
        }
        this.doLogRequest(exchange, level);
    }

    protected void doLogRequest(HttpExchange exchange, Level level) {
        Object[] requestInfo;
        if (log.isLoggable(level) && !Level.OFF.equals(level) && !Arrays.equals(requestInfo = new Object[]{exchange.getRemoteAddress(), exchange.getRequestMethod(), exchange.getRequestURI()}, BaseHttpHandler.getLastRequestInfo())) {
            BaseHttpHandler.setLastRequestInfo(requestInfo);
            log.log(level, JFaceMessages.get("msg.httpserver.log.request"), new Object[]{this.httpServerConfig.isSslEnabled() ? "HTTPS" : "HTTP", Thread.currentThread().getName(), exchange.getRemoteAddress(), exchange.getRequestMethod(), exchange.getRequestURI(), exchange.getProtocol()});
        }
    }

    protected void logResponse(HttpExchange exchange) {
        Level level = Level.OFF;
        try {
            level = Level.parse(this.httpServerConfig.getResponseLoggingLevel());
        }
        catch (RuntimeException e) {
            log.log(Level.WARNING, "Cannot log response:", e);
        }
        this.doLogResponse(exchange, level);
    }

    protected void doLogResponse(HttpExchange exchange, Level level) {
        Object[] responseInfo;
        if (log.isLoggable(level) && !Level.OFF.equals(level) && !Arrays.equals(responseInfo = new Object[]{exchange.getRemoteAddress(), exchange.getRequestMethod(), exchange.getRequestURI(), exchange.getProtocol(), exchange.getResponseCode()}, BaseHttpHandler.getLastResponseInfo())) {
            BaseHttpHandler.setLastResponseInfo(responseInfo);
            String textStatus = HttpStatusCodes.getDescription(exchange.getResponseCode());
            log.log(level, JFaceMessages.get("msg.httpserver.log.response"), new Object[]{this.httpServerConfig.isSslEnabled() ? "HTTPS" : "HTTP", Thread.currentThread().getName(), exchange.getRemoteAddress(), exchange.getRequestMethod(), exchange.getRequestURI(), exchange.getProtocol(), exchange.getResponseCode(), textStatus != null ? ' ' + textStatus : ""});
        }
    }

    protected Charset getCharset() {
        return charset;
    }

    public boolean isEnabled(HttpExchange exchange) {
        return this.isEnabled();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public String getPath() {
        return this.path != null ? this.path : BaseHttpHandler.getAnnotatedPath(this.getClass());
    }

    protected void setPath(String path) {
        this.path = path;
    }

    protected IHttpServerConfig getHttpServerConfig() {
        return this.httpServerConfig;
    }

    public static String getAnnotatedPath(Class<? extends HttpHandler> clazz) {
        Path annotation = clazz.getAnnotation(Path.class);
        return annotation != null ? annotation.value() : null;
    }

    protected static Object[] getLastRequestInfo() {
        return lastRequestInfo;
    }

    protected static void setLastRequestInfo(Object[] requestInfo) {
        lastRequestInfo = requestInfo;
    }

    protected static Object[] getLastResponseInfo() {
        return lastResponseInfo;
    }

    protected static void setLastResponseInfo(Object[] responseInfo) {
        lastResponseInfo = responseInfo;
    }

    public static synchronized Collection<Resource> getResources() {
        if (resources == null) {
            resources = BaseHttpHandler.initResources();
        }
        return resources;
    }

    private static MessageDigest newMd5Digest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        charset = StandardCharsets.UTF_8;
    }
}

