/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.net.httpserver;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class HttpDateGenerator {
    public static final String PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private final DateFormat dateformat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    private long dateAsLong = 0L;
    private String dateAsText = null;

    public HttpDateGenerator() {
        this.dateformat.setTimeZone(GMT);
    }

    public String getCurrentDate() {
        long now = System.currentTimeMillis();
        if (now - this.dateAsLong > 1000L) {
            this.dateAsText = this.dateformat.format(new Date(now));
            this.dateAsLong = now;
        }
        return this.dateAsText;
    }

    public String format(Date date) {
        return this.dateformat.format(date);
    }
}

