/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.net.httpserver;

import com.sun.net.httpserver.Authenticator;
import com.sun.net.httpserver.BasicAuthenticator;
import com.sun.net.httpserver.HttpExchange;
import io.github.albertus82.jface.JFaceMessages;
import io.github.albertus82.net.httpserver.config.IAuthenticatorConfig;
import io.github.albertus82.util.StringUtils;
import io.github.albertus82.util.logging.LoggerFactory;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;

public class HttpServerAuthenticator
extends BasicAuthenticator {
    private static final Logger log = LoggerFactory.getLogger(HttpServerAuthenticator.class);
    private final IAuthenticatorConfig configuration;
    private Charset charset = StandardCharsets.UTF_8;
    private final ThreadLocal<HttpExchange> exchanges = new ThreadLocal();

    public HttpServerAuthenticator(IAuthenticatorConfig configuration) {
        super(configuration.getRealm());
        this.configuration = configuration;
    }

    @Override
    public Authenticator.Result authenticate(HttpExchange exchange) {
        try {
            this.exchanges.set(exchange);
            Authenticator.Result result = super.authenticate(exchange);
            return result;
        }
        finally {
            this.exchanges.remove();
        }
    }

    @Override
    public boolean checkCredentials(String specifiedUsername, String specifiedPassword) {
        try {
            if (specifiedUsername == null || specifiedUsername.isEmpty() || specifiedPassword == null || specifiedPassword.isEmpty()) {
                return this.fail();
            }
            char[] expectedPassword = this.getConfiguration().getPassword(specifiedUsername);
            if (expectedPassword != null && expectedPassword.length > 0 && this.checkPassword(specifiedPassword, expectedPassword)) {
                return true;
            }
            HttpExchange exchange = this.exchanges.get();
            log.log(Level.parse(this.getConfiguration().getFailureLoggingLevel()), JFaceMessages.get("err.httpserver.authentication"), new Object[]{specifiedUsername, specifiedPassword, exchange != null ? exchange.getRemoteAddress() : null});
            return this.fail();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "An error occurred while checking credentials:", e);
            return this.fail();
        }
    }

    protected boolean checkPassword(String provided, char[] expected) {
        char[] computed = StringUtils.isNotBlank(this.configuration.getPasswordHashAlgorithm()) ? DatatypeConverter.printHexBinary((byte[])HttpServerAuthenticator.newMessageDigest(this.configuration.getPasswordHashAlgorithm().trim()).digest(provided.getBytes(this.charset))).toLowerCase(Locale.ROOT).toCharArray() : provided.toCharArray();
        boolean equal = true;
        if (computed.length != expected.length) {
            equal = false;
        }
        for (int i = 0; i < 1024; ++i) {
            if (computed[i % computed.length] == expected[i % expected.length]) continue;
            equal = false;
        }
        return equal;
    }

    protected boolean fail() {
        try {
            TimeUnit.MILLISECONDS.sleep(this.configuration.getFailDelayMillis());
        }
        catch (InterruptedException e) {
            log.log(Level.FINE, "Sleep interrupted:", e);
            Thread.currentThread().interrupt();
        }
        return false;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    protected IAuthenticatorConfig getConfiguration() {
        return this.configuration;
    }

    private static MessageDigest newMessageDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(algorithm, e);
        }
    }
}

