/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.net.httpserver;

import io.github.albertus82.util.IOUtils;
import io.github.albertus82.util.MapUtils;
import io.github.albertus82.util.logging.LoggerFactory;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

public class HttpStatusCodes {
    private static final String HTTP_CODES_RESOURCE_NAME = "http-codes.properties";
    private static final Map<Integer, String> map;

    private HttpStatusCodes() {
        throw new IllegalAccessError("Utility class");
    }

    public static Map<Integer, String> getMap() {
        return map;
    }

    public static String getDescription(int code) {
        return map.get(code);
    }

    static {
        Properties properties = new Properties();
        InputStream is = null;
        try {
            is = HttpStatusCodes.class.getResourceAsStream(HTTP_CODES_RESOURCE_NAME);
            properties.load(is);
        }
        catch (IOException e) {
            LoggerFactory.getLogger(HttpStatusCodes.class).log(Level.WARNING, "Unable to load resource http-codes.properties", e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)is);
        }
        map = MapUtils.newHashMapWithExpectedSize(properties.size());
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            map.put(Integer.valueOf(entry.getKey().toString()), entry.getValue().toString());
        }
    }
}

