/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.net.httpserver;

import com.sun.net.httpserver.Authenticator;
import com.sun.net.httpserver.Filter;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import com.sun.net.httpserver.HttpsServer;
import io.github.albertus82.jface.JFaceMessages;
import io.github.albertus82.net.httpserver.HttpPathHandler;
import io.github.albertus82.net.httpserver.config.IHttpServerConfig;
import io.github.albertus82.util.DaemonThreadFactory;
import io.github.albertus82.util.IOUtils;
import io.github.albertus82.util.logging.LoggerFactory;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;

public class LightweightHttpServer {
    private static final Logger log = LoggerFactory.getLogger(LightweightHttpServer.class);
    protected final IHttpServerConfig httpServerConfiguration;
    private HttpServer server;
    protected volatile boolean running = false;
    protected ThreadPoolExecutor threadPool;
    private Collection<HttpContext> contexts;
    private final Object lock = new Object();

    public LightweightHttpServer(IHttpServerConfig httpServerConfiguration) {
        this.httpServerConfiguration = httpServerConfiguration;
    }

    public void start() {
        this.start(true);
    }

    public void start(boolean daemon) {
        if (!this.running && this.httpServerConfiguration.isEnabled()) {
            new HttpServerStartThread(daemon).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(int delay) {
        if (this.server != null) {
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.server.stop(delay);
                    this.shutdownThreadPool();
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "An error occurred while stopping the server:", e);
                }
                this.running = false;
            }
        }
    }

    public void stop() {
        this.stop(this.httpServerConfiguration.getStopDelay());
    }

    private void shutdownThreadPool() {
        if (this.threadPool != null && !this.threadPool.isShutdown()) {
            try {
                this.threadPool.shutdown();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "An error occurred while stopping the thread pool executor:", e);
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public HttpServer getServer() {
        return this.server;
    }

    public Collection<HttpContext> getContexts() {
        return this.contexts;
    }

    protected Collection<HttpContext> createContexts() {
        Filter[] filtersArray = this.createFilters();
        List<Object> filtersList = filtersArray != null && filtersArray.length != 0 ? Arrays.asList(filtersArray) : Collections.emptyList();
        ArrayList<HttpContext> httpContexts = new ArrayList<HttpContext>();
        Authenticator authenticator = this.httpServerConfiguration.getAuthenticator();
        HttpPathHandler[] handlersArray = this.createHandlers();
        if (handlersArray != null && handlersArray.length > 0) {
            for (HttpPathHandler handler : handlersArray) {
                HttpContext httpContext = this.server.createContext(handler.getPath(), handler);
                if (filtersArray != null && filtersArray.length != 0) {
                    httpContext.getFilters().addAll(filtersList);
                }
                if (authenticator != null) {
                    httpContext.setAuthenticator(authenticator);
                }
                httpContexts.add(httpContext);
            }
        } else {
            log.log(Level.WARNING, JFaceMessages.get("msg.httpserver.configuration.handlers.none"));
        }
        return httpContexts;
    }

    protected HttpPathHandler[] createHandlers() {
        return this.httpServerConfiguration.getHandlers();
    }

    protected Filter[] createFilters() {
        return this.httpServerConfiguration.getFilters();
    }

    protected class HttpServerStartThread
    extends Thread {
        public HttpServerStartThread(boolean daemon) {
            this.setName("httpServerStartThread");
            this.setDaemon(daemon);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int port = LightweightHttpServer.this.httpServerConfiguration.getPort();
            InetSocketAddress address = new InetSocketAddress(port);
            try {
                Object object = LightweightHttpServer.this.lock;
                synchronized (object) {
                    block12: {
                        block11: {
                            System.setProperty("sun.net.httpserver.maxReqTime", Long.toString(LightweightHttpServer.this.httpServerConfiguration.getMaxReqTime()));
                            System.setProperty("sun.net.httpserver.maxRspTime", Long.toString(LightweightHttpServer.this.httpServerConfiguration.getMaxRspTime()));
                            if (!LightweightHttpServer.this.httpServerConfiguration.isSslEnabled()) break block11;
                            char[] storepass = LightweightHttpServer.this.httpServerConfiguration.getStorePass();
                            KeyStore keyStore = KeyStore.getInstance(LightweightHttpServer.this.httpServerConfiguration.getKeyStoreType());
                            FileInputStream fis = null;
                            BufferedInputStream bis = null;
                            try {
                                fis = new FileInputStream(LightweightHttpServer.this.httpServerConfiguration.getKeyStoreFileName());
                                bis = new BufferedInputStream(fis);
                                keyStore.load(bis, storepass);
                            }
                            catch (Throwable throwable) {
                                IOUtils.closeQuietly(bis, fis);
                                throw throwable;
                            }
                            IOUtils.closeQuietly(bis, fis);
                            char[] keypass = LightweightHttpServer.this.httpServerConfiguration.getKeyPass();
                            KeyManagerFactory kmf = KeyManagerFactory.getInstance(LightweightHttpServer.this.httpServerConfiguration.getKeyManagerFactoryAlgorithm());
                            kmf.init(keyStore, keypass);
                            TrustManagerFactory tmf = TrustManagerFactory.getInstance(LightweightHttpServer.this.httpServerConfiguration.getTrustManagerFactoryAlgorithm());
                            tmf.init(keyStore);
                            SSLContext sslContext = SSLContext.getInstance(LightweightHttpServer.this.httpServerConfiguration.getSslProtocol());
                            sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
                            final SSLParameters sslParameters = LightweightHttpServer.this.httpServerConfiguration.getSslParameters(sslContext);
                            log.log(Level.CONFIG, "SSLParameters [cipherSuites={0}, protocols={1}, wantClientAuth={2}, needClientAuth={3}]", new Object[]{Arrays.toString(sslParameters.getCipherSuites()), Arrays.toString(sslParameters.getProtocols()), sslParameters.getWantClientAuth(), sslParameters.getNeedClientAuth()});
                            HttpsConfigurator httpsConfigurator = new HttpsConfigurator(sslContext){

                                @Override
                                public void configure(HttpsParameters params) {
                                    params.setSSLParameters(sslParameters);
                                }
                            };
                            HttpsServer httpsServer = HttpsServer.create(address, 0);
                            httpsServer.setHttpsConfigurator(httpsConfigurator);
                            LightweightHttpServer.this.server = httpsServer;
                            break block12;
                        }
                        LightweightHttpServer.this.server = HttpServer.create(address, 0);
                    }
                    LightweightHttpServer.this.contexts = LightweightHttpServer.this.createContexts();
                    int maximumPoolSize = LightweightHttpServer.this.httpServerConfiguration.getMaxThreadCount();
                    if (maximumPoolSize > 1) {
                        LightweightHttpServer.this.threadPool = new ThreadPoolExecutor(LightweightHttpServer.this.httpServerConfiguration.getMinThreadCount(), maximumPoolSize, LightweightHttpServer.this.httpServerConfiguration.getThreadKeepAliveTime(), TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new DaemonThreadFactory());
                        LightweightHttpServer.this.threadPool.setRejectedExecutionHandler(new RejectedExecutionHandler(){

                            @Override
                            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                                try {
                                    executor.getQueue().put(r);
                                }
                                catch (InterruptedException e) {
                                    log.log(Level.FINE, "Interrupted while waiting for space to become available in the queue:", e);
                                    Thread.currentThread().interrupt();
                                }
                            }
                        });
                        LightweightHttpServer.this.server.setExecutor(LightweightHttpServer.this.threadPool);
                    }
                    LightweightHttpServer.this.server.start();
                    LightweightHttpServer.this.running = true;
                    log.log(Level.INFO, JFaceMessages.get("msg.httpserver.started", LightweightHttpServer.this.httpServerConfiguration.isSslEnabled() ? "HTTPS" : "HTTP", port));
                }
            }
            catch (BindException e) {
                log.log(Level.SEVERE, JFaceMessages.get("err.httpserver.start.port", port), e);
            }
            catch (FileNotFoundException e) {
                log.log(Level.SEVERE, JFaceMessages.get("err.httpserver.start.keystore.file"), e);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, JFaceMessages.get("err.httpserver.start"), e);
            }
        }
    }
}

