/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.net.httpserver;

import com.sun.net.httpserver.HttpExchange;
import io.github.albertus82.util.logging.LoggerFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RequestParameterExtractor {
    private static final Logger log = LoggerFactory.getLogger(RequestParameterExtractor.class);
    public static final String PREFERRED_CHARSET = "UTF-8";
    private final Map<String, String[]> parameterMap = new HashMap<String, String[]>();

    public RequestParameterExtractor(HttpExchange exchange, Charset charset) throws IOException {
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.putAll(this.parseQueryParameters(exchange, charset));
        if ("post".equalsIgnoreCase(exchange.getRequestMethod()) || "put".equalsIgnoreCase(exchange.getRequestMethod()) || "delete".equalsIgnoreCase(exchange.getRequestMethod()) || "patch".equalsIgnoreCase(exchange.getRequestMethod())) {
            params.putAll(this.parseBodyParameters(exchange, charset));
        }
        for (Map.Entry entry : params.entrySet()) {
            this.parameterMap.put((String)entry.getKey(), ((List)entry.getValue()).toArray(new String[((List)entry.getValue()).size()]));
        }
    }

    public RequestParameterExtractor(HttpExchange exchange, String charsetName) throws IOException {
        this(exchange, Charset.forName(charsetName));
    }

    public RequestParameterExtractor(HttpExchange exchange) throws IOException {
        this(exchange, RequestParameterExtractor.getDefaultCharset());
    }

    private static Charset getDefaultCharset() {
        String charsetName = PREFERRED_CHARSET;
        try {
            return Charset.forName(PREFERRED_CHARSET);
        }
        catch (RuntimeException e) {
            Charset defaultCharset = Charset.defaultCharset();
            log.log(Level.WARNING, "Cannot determine charset for name \"UTF-8\", falling back to " + defaultCharset + ':', e);
            return defaultCharset;
        }
    }

    public Map<String, String[]> getParameterMap() {
        return Collections.unmodifiableMap(this.parameterMap);
    }

    public String[] getParameterValues(String name) {
        return this.parameterMap.get(name);
    }

    public String getParameter(String name) {
        return this.parameterMap.containsKey(name) ? this.parameterMap.get(name)[0] : null;
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.getParameterMap().keySet());
    }

    private Map<String, List<String>> parseQueryParameters(HttpExchange exchange, Charset charset) throws UnsupportedEncodingException {
        URI requestedUri = exchange.getRequestURI();
        String query = requestedUri.getRawQuery();
        return this.parseQuery(query, charset);
    }

    private Map<String, List<String>> parseBodyParameters(HttpExchange exchange, Charset charset) throws IOException {
        InputStreamReader isr = new InputStreamReader(exchange.getRequestBody(), charset);
        BufferedReader br = new BufferedReader(isr);
        String query = br.readLine();
        return this.parseQuery(query, charset);
    }

    private Map<String, List<String>> parseQuery(String query, Charset charset) throws UnsupportedEncodingException {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        if (query != null) {
            String[] pairs;
            for (String pair : pairs = query.split("&")) {
                String[] param = pair.split("=");
                String key = null;
                String value = null;
                if (param.length > 0) {
                    key = URLDecoder.decode(param[0], charset.name());
                }
                if (param.length > 1) {
                    value = URLDecoder.decode(param[1], charset.name());
                }
                if (!map.containsKey(key)) {
                    map.put(key, new ArrayList(1));
                }
                ((List)map.get(key)).add(value);
            }
        }
        return map;
    }
}

