/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.net.httpserver;

import com.sun.net.httpserver.HttpExchange;
import io.github.albertus82.net.httpserver.AbstractStaticHandler;
import io.github.albertus82.net.httpserver.config.IHttpServerConfig;
import java.io.IOException;

public class ResourcesHandler
extends AbstractStaticHandler {
    public ResourcesHandler(IHttpServerConfig config, String resourceBasePath, String urlBasePath) {
        this(config);
        this.setBasePath(resourceBasePath);
        this.setPath(urlBasePath);
    }

    public ResourcesHandler(IHttpServerConfig config, Package resourceBasePackage, String urlBasePath) {
        this(config, resourceBasePackage != null ? resourceBasePackage.getName().replace('.', '/') : "/", urlBasePath);
    }

    public ResourcesHandler(IHttpServerConfig config) {
        super(config);
    }

    @Override
    protected void doGet(HttpExchange exchange) throws IOException {
        this.sendStaticResource(exchange, this.getBasePath() + this.getPathInfo(exchange), this.isAttachment(), this.getCacheControl());
    }

    @Override
    protected String normalizeBasePath(String resourceBasePath) {
        String normalizedBasePath = resourceBasePath;
        if (!resourceBasePath.startsWith("/")) {
            normalizedBasePath = '/' + normalizedBasePath;
        }
        if (!resourceBasePath.endsWith("/")) {
            normalizedBasePath = normalizedBasePath + Character.toString('/');
        }
        return normalizedBasePath;
    }
}

