/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.net.httpserver.config;

import com.sun.net.httpserver.Authenticator;
import com.sun.net.httpserver.Filter;
import io.github.albertus82.net.httpserver.config.IHttpServerConfig;
import io.github.albertus82.net.httpserver.filter.DateResponseFilter;
import io.github.albertus82.net.httpserver.filter.GzipRequestFilter;
import java.util.logging.Level;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;

public abstract class HttpServerDefaultConfig
implements IHttpServerConfig {
    public static final int PORT = 8080;
    public static final boolean ENABLED = true;
    public static final int MAX_THREAD_COUNT = 15;
    public static final int MIN_THREAD_COUNT = 1;
    public static final long THREAD_KEEP_ALIVE_TIME = 60L;
    public static final boolean SSL_ENABLED = false;
    public static final String SSL_KEYSTORE_TYPE = "JKS";
    public static final String SSL_PROTOCOL = "TLS";
    public static final String SSL_KMF_ALGORITHM = KeyManagerFactory.getDefaultAlgorithm();
    public static final String SSL_TMF_ALGORITHM = TrustManagerFactory.getDefaultAlgorithm();
    public static final long MAX_REQ_TIME = 60L;
    public static final long MAX_RSP_TIME = 86400L;
    public static final String REQUEST_LOGGING_LEVEL = Level.FINE.getName();
    public static final String RESPONSE_LOGGING_LEVEL = Level.INFO.getName();
    public static final boolean COMPRESSION_ENABLED = true;
    public static final int RESPONSE_BUFFER_LIMIT = 524288;
    public static final int STOP_DELAY = 0;
    public static final boolean TRACE_METHOD_ENABLED = false;

    @Override
    public Filter[] getFilters() {
        return new Filter[]{new GzipRequestFilter(), new DateResponseFilter()};
    }

    @Override
    public Authenticator getAuthenticator() {
        return null;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public int getPort() {
        return 8080;
    }

    @Override
    public long getMaxReqTime() {
        return 60L;
    }

    @Override
    public long getMaxRspTime() {
        return 86400L;
    }

    @Override
    public boolean isSslEnabled() {
        return false;
    }

    @Override
    public String getKeyStoreType() {
        return SSL_KEYSTORE_TYPE;
    }

    @Override
    public String getSslProtocol() {
        return SSL_PROTOCOL;
    }

    @Override
    public String getKeyManagerFactoryAlgorithm() {
        return SSL_KMF_ALGORITHM;
    }

    @Override
    public String getTrustManagerFactoryAlgorithm() {
        return SSL_TMF_ALGORITHM;
    }

    @Override
    public SSLParameters getSslParameters(SSLContext context) {
        return context.getDefaultSSLParameters();
    }

    @Override
    public int getMaxThreadCount() {
        return 15;
    }

    @Override
    public int getMinThreadCount() {
        return this.getMaxThreadCount() / 10;
    }

    @Override
    public long getThreadKeepAliveTime() {
        return 60L;
    }

    @Override
    public String getRequestLoggingLevel() {
        return REQUEST_LOGGING_LEVEL;
    }

    @Override
    public String getResponseLoggingLevel() {
        return RESPONSE_LOGGING_LEVEL;
    }

    @Override
    public boolean isCompressionEnabled() {
        return true;
    }

    @Override
    public int getResponseBufferLimit() {
        return 524288;
    }

    @Override
    public int getStopDelay() {
        return 0;
    }

    @Override
    public char[] getStorePass() {
        return null;
    }

    @Override
    public String getKeyStoreFileName() {
        return null;
    }

    @Override
    public char[] getKeyPass() {
        return null;
    }

    @Override
    public boolean isTraceMethodEnabled() {
        return false;
    }
}

