/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.net.httpserver.filter;

import com.sun.net.httpserver.Filter;
import com.sun.net.httpserver.HttpExchange;
import io.github.albertus82.util.ISupplier;
import java.io.IOException;
import javax.annotation.Nullable;

public class HSTSResponseFilter
extends Filter {
    private static final String HEADER_KEY = "Strict-Transport-Security";
    private ISupplier<Integer> maxAge;
    private ISupplier<Boolean> includeSubDomains;
    private ISupplier<Boolean> preload;
    private String headerValue;

    public HSTSResponseFilter(ISupplier<Integer> maxAge, ISupplier<Boolean> includeSubDomains, ISupplier<Boolean> preload) {
        this.maxAge = maxAge;
        this.includeSubDomains = includeSubDomains;
        this.preload = preload;
    }

    public HSTSResponseFilter(final int maxAge, boolean includeSubDomains, boolean preload) {
        this(new ISupplier<Integer>(){

            @Override
            public Integer get() {
                return maxAge;
            }
        }, HSTSResponseFilter.toSupplier(includeSubDomains), HSTSResponseFilter.toSupplier(preload));
    }

    public HSTSResponseFilter(@Nullable String headerValue) {
        if (headerValue == null) {
            throw new NullPointerException("The argument cannot be null.");
        }
        this.headerValue = headerValue;
    }

    @Override
    public void doFilter(HttpExchange exchange, Filter.Chain chain) throws IOException {
        exchange.getResponseHeaders().set(HEADER_KEY, this.getHeaderValue());
        chain.doFilter(exchange);
    }

    private String getHeaderValue() {
        if (this.headerValue != null) {
            return this.headerValue;
        }
        StringBuilder value = new StringBuilder("max-age=").append(this.maxAge.get());
        if (Boolean.TRUE.equals(this.includeSubDomains.get())) {
            value.append("; includeSubDomains");
        }
        if (Boolean.TRUE.equals(this.preload.get())) {
            value.append("; preload");
        }
        return value.toString();
    }

    @Override
    public String description() {
        return this.getClass().getSimpleName();
    }

    private static ISupplier<Boolean> toSupplier(final boolean value) {
        return new ISupplier<Boolean>(){

            @Override
            public Boolean get() {
                return value;
            }
        };
    }
}

