/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.net.httpserver.html;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class HtmlUtils {
    private static final Set<Character> charsToEscapeForEcmaScript = new HashSet<Character>(Arrays.asList(Character.valueOf('&'), Character.valueOf('\"'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('\''), Character.valueOf('/')));

    private HtmlUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static String escapeEcmaScript(String unescaped) {
        String escaped = unescaped.replace("\\", "\\\\");
        HashSet<Character> replacedChars = new HashSet<Character>();
        for (char c : escaped.toCharArray()) {
            if (replacedChars.contains(Character.valueOf(c)) || c >= ' ' && c <= '\u007f' && !charsToEscapeForEcmaScript.contains(Character.valueOf(c))) continue;
            escaped = escaped.replace(Character.toString(c), String.format(c > '\u00ff' ? "\\u%04X" : "\\x%02X", c));
            replacedChars.add(Character.valueOf(c));
        }
        return escaped;
    }

    public static String escapeHtml(String unescaped) {
        return unescaped.replace("&", "&amp;").replace("\"", "&quot;").replace("<", "&lt;").replace(">", "&gt;").replace("'", String.format("&#%d;", 39));
    }

    public static String unescapeHtml(String escaped) {
        return escaped.replace(String.format("&#%d;", 39), "'").replace("&gt;", ">").replace("&lt;", "<").replace("&quot;", "\"").replace("&amp;", "&");
    }
}

