/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.net.mqtt;

import com.sun.net.httpserver.Headers;
import io.github.albertus82.net.mqtt.MqttUtils;
import io.github.albertus82.util.NewLine;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class MqttPayload {
    private static final byte[] CRLF = NewLine.CRLF.toString().getBytes(MqttUtils.CHARSET_UTF8);
    private static final byte CR = CRLF[0];
    private static final byte LF = CRLF[1];
    private final Headers headers = new Headers();
    private final byte[] body;

    public MqttPayload(byte[] body) {
        if (body == null) {
            throw new NullPointerException("body cannot be null");
        }
        this.body = body;
    }

    public static MqttPayload fromPayload(byte[] payload) throws IOException {
        List<byte[]> tokens = MqttPayload.split(payload);
        if (tokens.size() < 2 || tokens.get(tokens.size() - 2).length != 0) {
            throw new IOException("Missing null line (double CRLF) between headers and body.");
        }
        byte[] body = tokens.get(tokens.size() - 1);
        MqttPayload instance = new MqttPayload(body);
        MqttPayload.parseHeaders(tokens.subList(0, tokens.size() - 2), instance.headers);
        return instance;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public byte[] getBody() {
        return this.body;
    }

    public byte[] toPayload() {
        if (!this.headers.containsKey("Content-Length")) {
            this.headers.set("Content-Length", Integer.toString(this.body.length));
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            MqttPayload.writeHeaders(this.headers, baos);
            baos.write(CRLF);
            baos.write(this.body);
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void writeHeaders(Headers source, OutputStream destination) throws IOException {
        for (Map.Entry<String, List<String>> entry : source.entrySet()) {
            String key;
            if (entry.getKey() == null || (key = entry.getKey().trim()).isEmpty()) continue;
            for (String value : entry.getValue()) {
                destination.write((key + ": " + (value != null ? value.trim() : "")).trim().getBytes(MqttUtils.CHARSET_UTF8));
                destination.write(CRLF);
            }
        }
    }

    private static void parseHeaders(Iterable<byte[]> source, Headers destination) {
        for (byte[] token : source) {
            String key;
            String headerLine = new String(token, MqttUtils.CHARSET_UTF8);
            int indexOfColon = headerLine.indexOf(58);
            if (indexOfColon == -1 || (key = headerLine.substring(0, indexOfColon).trim()).isEmpty()) continue;
            destination.add(key, headerLine.substring(indexOfColon + 1).trim());
        }
    }

    private static List<byte[]> split(byte[] payload) {
        ArrayList<byte[]> byteArrays = new ArrayList<byte[]>();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < payload.length; ++i) {
            if (payload.length > i + 3 && payload[i] == CR && payload[i + 1] == LF && payload[i + 2] == CR && payload[i + 3] == LF) {
                byteArrays.add(baos.toByteArray());
                byteArrays.add(new byte[0]);
                byteArrays.add(Arrays.copyOfRange(payload, i + 4, payload.length));
                break;
            }
            if (payload.length > i + 1 && payload[i] == CR && payload[i + 1] == LF) {
                byteArrays.add(baos.toByteArray());
                ++i;
                baos.reset();
                continue;
            }
            baos.write(payload[i]);
        }
        return byteArrays;
    }
}

