/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.net.mqtt;

import io.github.albertus82.net.mqtt.MqttPayload;
import io.github.albertus82.util.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;

public class MqttPayloadDecoder {
    private static final int BUFFER_SIZE = 4096;
    private final int bufferSize;

    public MqttPayloadDecoder() {
        this(4096);
    }

    public MqttPayloadDecoder(int bufferSize) {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.bufferSize = bufferSize;
    }

    public byte[] decode(byte[] payload) throws IOException {
        return this.decode(MqttPayload.fromPayload(payload));
    }

    byte[] decode(MqttPayload mqttPayload) throws IOException {
        int contentLength;
        if (mqttPayload.getHeaders().containsKey("Content-Length") && (contentLength = Integer.parseInt(mqttPayload.getHeaders().getFirst("Content-Length"))) != mqttPayload.getBody().length) {
            throw new IOException("Content-Length header value does not match the actual body length (expected: " + contentLength + ", actual: " + mqttPayload.getBody().length + ").");
        }
        if ("gzip".equalsIgnoreCase(mqttPayload.getHeaders().getFirst("Content-Encoding"))) {
            return this.decompress(mqttPayload.getBody());
        }
        return mqttPayload.getBody();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] decompress(byte[] compressed) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPInputStream gzis = null;
        try {
            gzis = new GZIPInputStream(new ByteArrayInputStream(compressed));
            IOUtils.copy((InputStream)gzis, (OutputStream)baos, this.bufferSize);
            gzis.close();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(gzis);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)gzis);
        return baos.toByteArray();
    }
}

