/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.net.mqtt;

import io.github.albertus82.net.httpserver.HttpDateGenerator;
import io.github.albertus82.net.mqtt.MqttPayload;
import io.github.albertus82.util.IOUtils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.util.Date;
import java.util.zip.GZIPOutputStream;

public class MqttPayloadEncoder {
    public MqttPayload encode(byte[] payloadToSend, boolean compress) {
        MqttPayload payload;
        if (compress) {
            payload = new MqttPayload(this.compress(payloadToSend));
            payload.getHeaders().set("Content-Encoding", "gzip");
        } else {
            payload = new MqttPayload(payloadToSend);
        }
        payload.getHeaders().set("Date", new HttpDateGenerator().format(new Date()));
        return payload;
    }

    protected byte[] compress(byte[] uncompressed) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gzos = null;
        try {
            gzos = new GZIPOutputStream(baos);
            gzos.write(uncompressed);
            gzos.close();
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(gzos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)gzos);
        return baos.toByteArray();
    }
}

