/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.util;

import java.io.OutputStream;
import java.util.zip.Checksum;

public class ChecksumOutputStream<T extends Checksum>
extends OutputStream {
    protected final T checksum;
    protected final int bits;

    public ChecksumOutputStream(T checksum, int bits) {
        this.checksum = checksum;
        this.bits = bits;
    }

    @Override
    public void write(int b) {
        this.checksum.update(b);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.checksum.update(b, off, len);
    }

    @Override
    public void close() {
    }

    public long getValue() {
        return this.checksum.getValue();
    }

    public void reset() {
        this.checksum.reset();
    }

    public String toString() {
        return String.format("%0" + this.bits / 4 + "x", this.checksum.getValue());
    }
}

