/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.util;

import io.github.albertus82.util.Resource;
import io.github.albertus82.util.logging.LoggerFactory;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClasspathResourceUtils {
    private static final int THRESHOLD_ENTRIES = 65535;
    private static final Logger log = LoggerFactory.getLogger(ClasspathResourceUtils.class);

    private ClasspathResourceUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static List<Resource> getResourceList(Pattern pattern) {
        String[] classPathElements;
        ArrayList<Resource> retval = new ArrayList<Resource>();
        String classPath = System.getProperty("java.class.path", ".");
        for (String element : classPathElements = classPath.split(System.getProperty("path.separator"))) {
            retval.addAll(ClasspathResourceUtils.getResources(element, pattern));
        }
        return retval;
    }

    private static List<Resource> getResources(String element, Pattern pattern) {
        ArrayList<Resource> retval = new ArrayList<Resource>();
        File file = new File(element);
        if (file.isDirectory()) {
            retval.addAll(ClasspathResourceUtils.getResourcesFromDirectory(file, pattern));
        } else {
            retval.addAll(ClasspathResourceUtils.getResourcesFromJarFile(file, pattern));
        }
        return retval;
    }

    private static List<Resource> getResourcesFromJarFile(File file, Pattern pattern) {
        ArrayList<Resource> retval = new ArrayList<Resource>();
        ZipFile zf = null;
        try {
            zf = new ZipFile(file);
            String currentPath = new File("").getCanonicalPath();
            log.log(Level.FINEST, "currentPath: {0}", currentPath);
            Enumeration<? extends ZipEntry> e = zf.entries();
            int entryCount = 0;
            while (e.hasMoreElements()) {
                if (++entryCount > 65535) {
                    log.log(Level.WARNING, "Too many ZIP entries!");
                    break;
                }
                ZipEntry ze = e.nextElement();
                String fileName = ze.getName();
                String entryPath = new File(currentPath, fileName).getCanonicalPath();
                log.log(Level.FINEST, "entryPath: {0}", entryPath);
                if (!entryPath.startsWith(currentPath)) {
                    log.log(Level.WARNING, "Ignoring ZIP entry {0} not within target directory!", ze);
                    continue;
                }
                boolean accept = pattern.matcher(fileName).matches();
                if (!accept || ze.isDirectory()) continue;
                retval.add(new Resource(fileName, ze.getSize(), ze.getTime()));
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        finally {
            if (zf != null) {
                try {
                    zf.close();
                }
                catch (IOException e) {
                    log.log(Level.WARNING, "Exception closing " + zf, e);
                }
            }
        }
        return retval;
    }

    private static List<Resource> getResourcesFromDirectory(File directory, Pattern pattern) {
        File[] fileList;
        ArrayList<Resource> retval = new ArrayList<Resource>();
        for (File file : fileList = directory.listFiles()) {
            if (file.isDirectory()) {
                retval.addAll(ClasspathResourceUtils.getResourcesFromDirectory(file, pattern));
                continue;
            }
            String fileName = file.getPath();
            boolean accept = pattern.matcher(fileName).matches();
            if (!accept) continue;
            retval.add(new Resource(fileName, file.length(), file.lastModified()));
        }
        return retval;
    }

    public static void main(String[] args) {
        Pattern pattern = args.length < 1 ? Pattern.compile(".*") : Pattern.compile(args[0]);
        List<Resource> list = ClasspathResourceUtils.getResourceList(pattern);
        for (Resource name : list) {
            System.out.println(name);
        }
    }
}

