/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.util;

import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import javax.xml.bind.DatatypeConverter;

public class DigestOutputStream
extends OutputStream {
    private final MessageDigest digest;
    private byte[] result;

    public DigestOutputStream(MessageDigest digest) {
        digest.reset();
        this.digest = digest;
    }

    public DigestOutputStream(String algorithm) throws NoSuchAlgorithmException {
        this.digest = MessageDigest.getInstance(algorithm);
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.ensureOpen();
        this.digest.update((byte)b);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        this.digest.update(b, off, len);
    }

    @Override
    public synchronized void write(byte[] b) throws IOException {
        this.ensureOpen();
        this.digest.update(b);
    }

    @Override
    public synchronized void close() {
        if (this.result == null) {
            this.result = this.digest.digest();
        }
    }

    public byte[] getValue() {
        return this.result;
    }

    public String toString() {
        byte[] value = this.getValue();
        if (value != null) {
            return DatatypeConverter.printHexBinary((byte[])value).toLowerCase(Locale.ROOT);
        }
        return "";
    }

    private void ensureOpen() throws IOException {
        if (this.result != null) {
            throw new IOException("Stream closed");
        }
    }
}

