/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.util;

import javax.annotation.Nullable;

public class EmailUtils {
    private EmailUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static boolean validateAddress(@Nullable String address) {
        if (address == null) {
            return false;
        }
        if (address.startsWith(" ") || address.endsWith(" ")) {
            return false;
        }
        if ((address = address.trim()).indexOf(64) == -1 || address.length() < 3) {
            return false;
        }
        String local = address.substring(0, address.lastIndexOf(64));
        if (local.trim().isEmpty()) {
            return false;
        }
        if (local.endsWith(" ")) {
            return false;
        }
        if (local.indexOf(64) != -1 && local.indexOf(34) == local.lastIndexOf(34)) {
            return false;
        }
        String domain = address.substring(address.lastIndexOf(64) + 1);
        if (domain.trim().isEmpty()) {
            return false;
        }
        if (domain.startsWith(".") || domain.endsWith(".")) {
            return false;
        }
        if (domain.startsWith(" ")) {
            return false;
        }
        return !domain.contains("..");
    }
}

