/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.util;

import io.github.albertus82.util.IOUtils;
import io.github.albertus82.util.StringUtils;
import io.github.albertus82.util.logging.LoggerFactory;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExceptionUtils {
    private static final Logger log = LoggerFactory.getLogger(ExceptionUtils.class);

    private ExceptionUtils() {
        throw new IllegalAccessError("Utility class");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStackTrace(Throwable e) {
        if (e != null) {
            String string;
            StringWriter sw = null;
            PrintWriter pw = null;
            try {
                sw = new StringWriter();
                pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                string = sw.toString();
            }
            catch (RuntimeException re) {
                try {
                    log.log(Level.WARNING, "Cannot convert stack trace to string:", re);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(pw, sw);
                    throw throwable;
                }
                IOUtils.closeQuietly(pw, sw);
            }
            IOUtils.closeQuietly(pw, sw);
            return string;
        }
        return "";
    }

    public static String getUIMessage(Throwable throwable) {
        String message = "";
        if (throwable != null) {
            message = StringUtils.isNotBlank(throwable.getLocalizedMessage()) ? throwable.getLocalizedMessage() : (StringUtils.isNotBlank(throwable.getMessage()) ? throwable.getMessage() : throwable.getClass().getSimpleName());
            if (StringUtils.isNotBlank(message) && !(message = message.trim()).endsWith(".")) {
                message = message + ".";
            }
        }
        return message;
    }

    public static String getLogMessage(Throwable throwable) {
        String message = "";
        if (throwable != null) {
            message = throwable.getClass().getSimpleName();
            if (StringUtils.isNotBlank(throwable.getLocalizedMessage()) || StringUtils.isNotBlank(throwable.getMessage())) {
                message = message + ": " + (StringUtils.isNotBlank(throwable.getLocalizedMessage()) ? throwable.getLocalizedMessage() : throwable.getMessage());
            }
            if (StringUtils.isNotBlank(message) && !(message = message.trim()).endsWith(".")) {
                message = message + ".";
            }
        }
        return message;
    }
}

