/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.util;

import io.github.albertus82.util.logging.LoggerFactory;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipFile;

public class IOUtils {
    private static final Logger log = LoggerFactory.getLogger(IOUtils.class);
    public static final int EOF = -1;

    private IOUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static void closeQuietly(Closeable ... closeables) {
        for (Closeable closeable : closeables) {
            IOUtils.closeQuietly(closeable);
        }
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            log.log(Level.FINE, "An error occurred while closing the resource:", e);
        }
    }

    public static void closeQuietly(ZipFile zipFile) {
        try {
            if (zipFile != null) {
                zipFile.close();
            }
        }
        catch (IOException e) {
            log.log(Level.FINE, "An error occurred while closing the ZIP file:", e);
        }
    }

    public static long copy(InputStream input, OutputStream output, byte[] buffer) throws IOException {
        int n;
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static long copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        return IOUtils.copy(input, output, new byte[bufferSize]);
    }

    public static long copy(Reader input, Writer output, char[] buffer) throws IOException {
        int n;
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static long copy(Reader input, Writer output, int bufferSize) throws IOException {
        return IOUtils.copy(input, output, new char[bufferSize]);
    }
}

