/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.util;

import java.io.File;

class Pair
implements Comparable<Pair> {
    private final long time;
    private final File file;

    Pair(File file) {
        this.file = file;
        this.time = file.lastModified();
    }

    @Override
    public int compareTo(Pair other) {
        return this.time < other.time ? -1 : (this.time == other.time ? 0 : 1);
    }

    long getTime() {
        return this.time;
    }

    File getFile() {
        return this.file;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        result = 31 * result + (int)(this.time ^ this.time >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Pair)) {
            return false;
        }
        Pair other = (Pair)obj;
        if (this.file == null ? other.file != null : !this.file.equals(other.file)) {
            return false;
        }
        return this.time == other.time;
    }
}

