/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;

public class PropertiesComparator {
    private PropertiesComparator() {
        throw new IllegalAccessError();
    }

    public static CompareResults compare(Properties left, Properties right) {
        Set<String> leftKeys = left.stringPropertyNames();
        Set<String> rightKeys = right.stringPropertyNames();
        HashSet<String> removedKeys = new HashSet<String>(leftKeys);
        removedKeys.removeAll(rightKeys);
        Properties leftOnly = new Properties();
        for (String removedKey : removedKeys) {
            leftOnly.setProperty(removedKey, left.getProperty(removedKey));
        }
        HashSet<String> addedKeys = new HashSet<String>(rightKeys);
        addedKeys.removeAll(leftKeys);
        Properties rightOnly = new Properties();
        for (String addedKey : addedKeys) {
            rightOnly.setProperty(addedKey, right.getProperty(addedKey));
        }
        HashSet<String> commonKeys = new HashSet<String>(leftKeys);
        commonKeys.retainAll(rightKeys);
        HashSet<String> modifiedKeys = new HashSet<String>();
        for (String commonkey : commonKeys) {
            if (left.getProperty(commonkey).equals(right.getProperty(commonkey))) continue;
            modifiedKeys.add(commonkey);
        }
        TreeMap<String, List<String>> differentValues = new TreeMap<String, List<String>>();
        for (String modifiedKey : modifiedKeys) {
            ArrayList<String> values = new ArrayList<String>(2);
            values.add(left.getProperty(modifiedKey));
            values.add(right.getProperty(modifiedKey));
            differentValues.put(modifiedKey, Collections.unmodifiableList(values));
        }
        return new CompareResults(leftOnly, rightOnly, differentValues);
    }

    public static class CompareResults {
        private final Properties leftOnly;
        private final Properties rightOnly;
        private final Map<String, List<String>> differentValues;

        public CompareResults(Properties leftOnly, Properties rightOnly, Map<String, List<String>> differentValues) {
            this.leftOnly = leftOnly;
            this.rightOnly = rightOnly;
            this.differentValues = differentValues;
        }

        public Properties getLeftOnly() {
            return this.leftOnly;
        }

        public Properties getRightOnly() {
            return this.rightOnly;
        }

        public Map<String, List<String>> getDifferentValues() {
            return this.differentValues;
        }
    }
}

