/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.util;

import io.github.albertus82.util.StringUtils;
import java.io.File;
import java.util.Locale;
import javax.swing.filechooser.FileSystemView;

public class SystemUtils {
    private static final String USER_HOME = "user.home";
    private static final String OS_NAME = "os.name";
    private static String osSpecificDocumentsDir;
    private static String osSpecificConfigurationDir;
    private static String osSpecificLocalAppDataDir;

    private SystemUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static synchronized String getOsSpecificConfigurationDir() {
        if (osSpecificConfigurationDir == null) {
            String os = StringUtils.trimToEmpty(System.getProperty(OS_NAME)).toLowerCase(Locale.ROOT);
            osSpecificConfigurationDir = os.contains("win") && System.getenv("APPDATA") != null ? System.getenv("APPDATA") : (os.contains("mac") ? System.getProperty(USER_HOME) + File.separator + "Library" + File.separator + "Preferences" : System.getProperty(USER_HOME));
        }
        return osSpecificConfigurationDir;
    }

    public static synchronized String getOsSpecificLocalAppDataDir() {
        if (osSpecificLocalAppDataDir == null) {
            String os = StringUtils.trimToEmpty(System.getProperty(OS_NAME)).toLowerCase(Locale.ROOT);
            osSpecificLocalAppDataDir = os.contains("win") && System.getenv("LOCALAPPDATA") != null ? System.getenv("LOCALAPPDATA") : (os.contains("mac") ? System.getProperty(USER_HOME) + File.separator + "Library" : System.getProperty(USER_HOME));
        }
        return osSpecificLocalAppDataDir;
    }

    public static synchronized String getOsSpecificDocumentsDir() {
        if (osSpecificDocumentsDir == null) {
            String os = StringUtils.trimToEmpty(System.getProperty(OS_NAME)).toLowerCase(Locale.ROOT);
            osSpecificDocumentsDir = os.contains("win") ? FileSystemView.getFileSystemView().getDefaultDirectory().getPath() : (os.contains("mac") ? System.getProperty(USER_HOME) + File.separator + "Documents" : System.getProperty(USER_HOME));
        }
        return osSpecificDocumentsDir;
    }
}

