/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.util;

import io.github.albertus82.util.CRC32OutputStream;
import io.github.albertus82.util.IOUtils;
import io.github.albertus82.util.logging.LoggerFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    public static final String ZIP_FILE_EXTENSION = ".zip";
    private static final Logger log = LoggerFactory.getLogger(ZipUtils.class);
    private static final int THRESHOLD_ENTRIES = 65535;

    private ZipUtils() {
        throw new IllegalAccessError("Utility class");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(File destination, File ... sources) throws IOException {
        if (!destination.exists() || !ZipUtils.isValid(destination)) {
            FileOutputStream fos = null;
            ZipOutputStream zos = null;
            try {
                fos = new FileOutputStream(destination);
                zos = new ZipOutputStream(fos);
                zos.setLevel(9);
                for (File file : sources) {
                    ZipUtils.compress(zos, file);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zos, fos);
                throw throwable;
            }
            IOUtils.closeQuietly(zos, fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void compress(ZipOutputStream zos, File file) throws IOException {
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            fis = new FileInputStream(file);
            bis = new BufferedInputStream(fis);
            zos.putNextEntry(new ZipEntry(file.getName()));
            IOUtils.copy((InputStream)bis, (OutputStream)zos, 1024);
        }
        catch (Throwable throwable) {
            try {
                zos.closeEntry();
            }
            catch (Throwable throwable2) {
                IOUtils.closeQuietly(bis, fis);
                throw throwable2;
            }
            IOUtils.closeQuietly(bis, fis);
            throw throwable;
        }
        try {
            zos.closeEntry();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bis, fis);
            throw throwable;
        }
        IOUtils.closeQuietly(bis, fis);
    }

    public static boolean isValid(File zipFile) {
        try {
            ZipUtils.test(zipFile);
            return true;
        }
        catch (Exception e) {
            log.log(Level.FINE, "An error occurred while validating the ZIP file:", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void test(File zipFile) throws IOException {
        String currentPath = new File("").getCanonicalPath();
        log.log(Level.FINEST, "currentPath: {0}", currentPath);
        ZipFile zf = null;
        try {
            zf = new ZipFile(zipFile);
            Enumeration<? extends ZipEntry> e = zf.entries();
            if (!e.hasMoreElements()) {
                throw new IOException("No ZIP entries found");
            }
            int entryCount = 0;
            while (e.hasMoreElements()) {
                if (++entryCount > 65535) {
                    throw new SecurityException("Too many ZIP entries");
                }
                ZipEntry ze = e.nextElement();
                long expectedCrc = ze.getCrc();
                String fileName = ze.getName();
                String entryPath = new File(currentPath, fileName).getCanonicalPath();
                log.log(Level.FINEST, "entryPath: {0}", entryPath);
                if (!entryPath.startsWith(currentPath)) {
                    throw new SecurityException("ZIP entry not within target directory: " + entryPath);
                }
                InputStream is = null;
                CRC32OutputStream cos = null;
                try {
                    is = zf.getInputStream(ze);
                    cos = new CRC32OutputStream();
                    IOUtils.copy(is, (OutputStream)cos, 1024);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(cos, is);
                    throw throwable;
                }
                IOUtils.closeQuietly(cos, is);
                long actualCrc = cos.getValue();
                if (expectedCrc == actualCrc) continue;
                throw new IOException(String.format("Invalid CRC value for file \"%s\", expected 0x%08X, actual 0x%08X", fileName, expectedCrc, actualCrc));
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(zf);
            throw throwable;
        }
        IOUtils.closeQuietly(zf);
    }
}

