/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.util.config;

import io.github.albertus82.jface.JFaceMessages;
import io.github.albertus82.util.ConfigurationException;
import io.github.albertus82.util.config.IConfiguration;
import io.github.albertus82.util.config.IPropertiesConfiguration;
import io.github.albertus82.util.logging.LoggerFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Configuration
implements IConfiguration {
    private static final Logger log = LoggerFactory.getLogger(Configuration.class);
    private final IPropertiesConfiguration propertiesConfiguration;

    public Configuration(IPropertiesConfiguration propertiesConfiguration) {
        this.propertiesConfiguration = propertiesConfiguration;
    }

    @Override
    public String getString(String key) {
        return this.getProperties().getProperty(key);
    }

    @Override
    public String getString(String key, String defaultValue) {
        return this.getProperties().getProperty(key, defaultValue);
    }

    @Override
    public String getString(String key, boolean emptyIfNull) {
        return emptyIfNull ? this.getString(key, "") : this.getString(key);
    }

    @Override
    public char[] getCharArray(String key) {
        String value = this.getProperties().getProperty(key);
        if (value != null) {
            return value.toCharArray();
        }
        return null;
    }

    @Override
    public Boolean getBoolean(String key) {
        String value = this.getString(key);
        if (value == null) {
            return null;
        }
        String trimmedValue = value.trim();
        if (trimmedValue.isEmpty()) {
            return null;
        }
        return Configuration.parseBoolean(trimmedValue);
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        Boolean value = this.getBoolean(key);
        return value != null ? value : defaultValue;
    }

    @Override
    public Long getLong(String key) {
        String value = this.getString(key);
        if (value == null) {
            return null;
        }
        String trimmedValue = value.trim();
        if (trimmedValue.isEmpty()) {
            return null;
        }
        try {
            return Long.valueOf(trimmedValue);
        }
        catch (NumberFormatException nfe) {
            throw new ConfigurationException(this.getInvalidNumberErrorMessage(key, Long.MIN_VALUE, Long.MAX_VALUE), nfe, key);
        }
    }

    @Override
    public long getLong(String key, long defaultValue) {
        Long value;
        try {
            value = this.getLong(key);
        }
        catch (ConfigurationException e) {
            log.log(Level.FINE, "Unable to get long value from configuration:", e);
            log.log(Level.WARNING, this.getInvalidNumberErrorMessage(key, Long.MIN_VALUE, Long.MAX_VALUE, defaultValue));
            value = defaultValue;
        }
        return value != null ? value : defaultValue;
    }

    @Override
    public Integer getInt(String key) {
        String value = this.getString(key);
        if (value == null) {
            return null;
        }
        String trimmedValue = value.trim();
        if (trimmedValue.isEmpty()) {
            return null;
        }
        try {
            return Integer.valueOf(trimmedValue);
        }
        catch (NumberFormatException nfe) {
            throw new ConfigurationException(this.getInvalidNumberErrorMessage(key, Integer.MIN_VALUE, Integer.MAX_VALUE), nfe, key);
        }
    }

    @Override
    public int getInt(String key, int defaultValue) {
        Integer value;
        try {
            value = this.getInt(key);
        }
        catch (ConfigurationException e) {
            log.log(Level.FINE, "Unable to get int value from configuration:", e);
            log.log(Level.WARNING, this.getInvalidNumberErrorMessage(key, Integer.MIN_VALUE, Integer.MAX_VALUE, defaultValue));
            value = defaultValue;
        }
        return value != null ? value : defaultValue;
    }

    @Override
    public Short getShort(String key) {
        String value = this.getString(key);
        if (value == null) {
            return null;
        }
        String trimmedValue = value.trim();
        if (trimmedValue.isEmpty()) {
            return null;
        }
        try {
            return Short.valueOf(trimmedValue);
        }
        catch (NumberFormatException nfe) {
            throw new ConfigurationException(this.getInvalidNumberErrorMessage(key, (short)Short.MIN_VALUE, (short)Short.MAX_VALUE), nfe, key);
        }
    }

    @Override
    public short getShort(String key, short defaultValue) {
        Short value;
        try {
            value = this.getShort(key);
        }
        catch (ConfigurationException e) {
            log.log(Level.FINE, "Unable to get short value from configuration:", e);
            log.log(Level.WARNING, this.getInvalidNumberErrorMessage(key, (short)Short.MIN_VALUE, (short)Short.MAX_VALUE, defaultValue), e);
            value = defaultValue;
        }
        return value != null ? value : defaultValue;
    }

    @Override
    public Byte getByte(String key) {
        String value = this.getString(key);
        if (value == null) {
            return null;
        }
        String trimmedValue = value.trim();
        if (trimmedValue.isEmpty()) {
            return null;
        }
        try {
            return Byte.valueOf(trimmedValue);
        }
        catch (NumberFormatException nfe) {
            throw new ConfigurationException(this.getInvalidNumberErrorMessage(key, (byte)-128, (byte)127), nfe, key);
        }
    }

    @Override
    public byte getByte(String key, byte defaultValue) {
        Byte value;
        try {
            value = this.getByte(key);
        }
        catch (ConfigurationException e) {
            log.log(Level.FINE, "Unable to get byte value from configuration:", e);
            log.log(Level.WARNING, this.getInvalidNumberErrorMessage(key, (byte)-128, (byte)127, defaultValue));
            value = defaultValue;
        }
        return value != null ? value : defaultValue;
    }

    @Override
    public Float getFloat(String key) {
        String value = this.getString(key);
        if (value == null) {
            return null;
        }
        String trimmedValue = value.trim();
        if (trimmedValue.isEmpty()) {
            return null;
        }
        try {
            return Float.valueOf(trimmedValue);
        }
        catch (NumberFormatException nfe) {
            throw new ConfigurationException(this.getInvalidNumberErrorMessage(key, Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE)), nfe, key);
        }
    }

    @Override
    public float getFloat(String key, float defaultValue) {
        Float value;
        try {
            value = this.getFloat(key);
        }
        catch (ConfigurationException e) {
            log.log(Level.FINE, "Unable to get float value from configuration:", e);
            log.log(Level.WARNING, this.getInvalidNumberErrorMessage(key, Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE), Float.valueOf(defaultValue)));
            value = Float.valueOf(defaultValue);
        }
        return value != null ? value.floatValue() : defaultValue;
    }

    @Override
    public Double getDouble(String key) {
        String value = this.getString(key);
        if (value == null) {
            return null;
        }
        String trimmedValue = value.trim();
        if (trimmedValue.isEmpty()) {
            return null;
        }
        try {
            return Double.valueOf(trimmedValue);
        }
        catch (NumberFormatException nfe) {
            throw new ConfigurationException(this.getInvalidNumberErrorMessage(key, Double.MIN_VALUE, Double.MAX_VALUE), nfe, key);
        }
    }

    @Override
    public double getDouble(String key, double defaultValue) {
        Double value;
        try {
            value = this.getDouble(key);
        }
        catch (ConfigurationException e) {
            log.log(Level.FINE, "Unable to get double value from configuration:", e);
            log.log(Level.WARNING, this.getInvalidNumberErrorMessage(key, Double.MIN_VALUE, Double.MAX_VALUE, defaultValue));
            value = defaultValue;
        }
        return value != null ? value : defaultValue;
    }

    @Override
    public BigDecimal getBigDecimal(String key) {
        String value = this.getString(key);
        if (value == null) {
            return null;
        }
        String trimmedValue = value.trim();
        if (trimmedValue.isEmpty()) {
            return null;
        }
        try {
            return new BigDecimal(trimmedValue);
        }
        catch (NumberFormatException nfe) {
            throw new ConfigurationException(this.getInvalidNumberErrorMessage(key), nfe, key);
        }
    }

    @Override
    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        BigDecimal value;
        try {
            value = this.getBigDecimal(key);
        }
        catch (ConfigurationException e) {
            log.log(Level.FINE, "Unable to get BigDecimal value from configuration:", e);
            log.log(Level.WARNING, this.getInvalidNumberErrorMessage(key, defaultValue));
            value = defaultValue;
        }
        return value != null ? value : defaultValue;
    }

    @Override
    public BigInteger getBigInteger(String key) {
        String value = this.getString(key);
        if (value == null) {
            return null;
        }
        String trimmedValue = value.trim();
        if (trimmedValue.isEmpty()) {
            return null;
        }
        try {
            return new BigInteger(trimmedValue);
        }
        catch (NumberFormatException nfe) {
            throw new ConfigurationException(this.getInvalidNumberErrorMessage(key), nfe, key);
        }
    }

    @Override
    public BigInteger getBigInteger(String key, BigInteger defaultValue) {
        BigInteger value;
        try {
            value = this.getBigInteger(key);
        }
        catch (ConfigurationException e) {
            log.log(Level.FINE, "Unable to get BigInteger value from configuration:", e);
            log.log(Level.WARNING, this.getInvalidNumberErrorMessage(key, defaultValue));
            value = defaultValue;
        }
        return value != null ? value : defaultValue;
    }

    @Override
    public Character getChar(String key) {
        String value = this.getString(key);
        if (value == null || value.isEmpty()) {
            return null;
        }
        try {
            return Character.valueOf(Configuration.parseChar(value));
        }
        catch (IllegalArgumentException iae) {
            throw new ConfigurationException(this.getInvalidCharacterErrorMessage(key), iae, key);
        }
    }

    @Override
    public char getChar(String key, char defaultValue) {
        Character value;
        try {
            value = this.getChar(key);
        }
        catch (ConfigurationException e) {
            log.log(Level.FINE, "Unable to get char value from configuration:", e);
            log.log(Level.WARNING, this.getInvalidCharacterErrorMessage(key, Character.valueOf(defaultValue)));
            value = Character.valueOf(defaultValue);
        }
        return value != null ? value.charValue() : defaultValue;
    }

    @Override
    public boolean contains(String key) {
        return this.getProperties().containsKey(key);
    }

    private String getInvalidCharacterErrorMessage(String key) {
        return this.getInvalidCharacterErrorMessage(key, null);
    }

    private String getInvalidCharacterErrorMessage(String key, Character defaultValue) {
        StringBuilder message = new StringBuilder(JFaceMessages.get("err.configuration.invalid.char", key));
        if (defaultValue != null) {
            message.append(' ').append(JFaceMessages.get("err.configuration.using.default", "'" + defaultValue.toString() + "'"));
        }
        return message.append(' ').append(JFaceMessages.get("err.configuration.review", this.getFileName())).toString();
    }

    private String getInvalidNumberErrorMessage(String key) {
        return this.getInvalidNumberErrorMessage(key, null);
    }

    private String getInvalidNumberErrorMessage(String key, Number defaultValue) {
        return this.getInvalidNumberErrorMessage(key, null, null, defaultValue);
    }

    private String getInvalidNumberErrorMessage(String key, Number min, Number max) {
        return this.getInvalidNumberErrorMessage(key, min, max, null);
    }

    private String getInvalidNumberErrorMessage(String key, Number min, Number max, Number defaultValue) {
        StringBuilder message = new StringBuilder();
        if (min != null && max != null) {
            message.append(JFaceMessages.get("err.configuration.invalid.number", key, min, max));
        } else {
            message.append(JFaceMessages.get("err.configuration.invalid", key));
        }
        if (defaultValue != null) {
            message.append(' ').append(JFaceMessages.get("err.configuration.using.default", defaultValue));
        }
        return message.append(' ').append(JFaceMessages.get("err.configuration.review", this.getFileName())).toString();
    }

    public static boolean parseBoolean(String value) {
        if ("1".equals(value)) {
            return true;
        }
        if ("0".equals(value)) {
            return false;
        }
        return Boolean.parseBoolean(value);
    }

    public static char parseChar(String value) {
        if (value.length() == 1) {
            return value.charAt(0);
        }
        throw new IllegalArgumentException("value length != 1");
    }

    @Override
    public String getFileName() {
        return this.propertiesConfiguration.getFileName();
    }

    @Override
    public Properties getProperties() {
        return this.propertiesConfiguration.getProperties();
    }

    @Override
    public void save() throws IOException {
        this.propertiesConfiguration.save();
    }

    @Override
    public void reload() throws IOException {
        this.propertiesConfiguration.reload();
    }

    public String toString() {
        return this.propertiesConfiguration.toString();
    }
}

