/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.util.config;

import io.github.albertus82.util.IOUtils;
import io.github.albertus82.util.SystemUtils;
import io.github.albertus82.util.config.IPropertiesConfiguration;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;
import java.util.TreeMap;

public class PropertiesConfiguration
implements IPropertiesConfiguration {
    static final String PASSWORD_PLACEHOLDER = "********";
    private final String fileName;
    private final Properties properties = new Properties();

    public PropertiesConfiguration(String propertiesFileName) throws IOException {
        this.fileName = propertiesFileName;
        this.load();
    }

    public PropertiesConfiguration(String propertiesFileName, boolean prependOsSpecificConfigurationDir) throws IOException {
        this(prependOsSpecificConfigurationDir ? SystemUtils.getOsSpecificConfigurationDir() + File.separator + propertiesFileName : propertiesFileName);
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void reload() throws IOException {
        this.load();
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void save() throws IOException {
        File file = new File(this.getFileName());
        file.getParentFile().mkdirs();
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(file);
            this.properties.store(outputStream, null);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(outputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load() throws IOException {
        File file = new File(this.getFileName());
        if (file.exists()) {
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(file);
                Properties properties = this.properties;
                synchronized (properties) {
                    this.properties.clear();
                    this.properties.load(inputStream);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)inputStream);
        }
    }

    public String toString() {
        TreeMap<String, String> props = new TreeMap<String, String>();
        for (Object key : this.getProperties().keySet()) {
            props.put(key.toString(), key.toString().toLowerCase().contains("password") || key.toString().toLowerCase(Locale.ROOT).contains("password") ? PASSWORD_PLACEHOLDER : this.getProperties().getProperty(key.toString()));
        }
        return ((Object)props).toString();
    }
}

