/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.util.logging;

import io.github.albertus82.util.logging.CustomFormatter;
import io.github.albertus82.util.logging.annotation.ExcludeLoggers;
import io.github.albertus82.util.logging.annotation.LogFormat;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public abstract class AnnotationConfigHandler
extends Handler {
    private final String[] exclusions;

    protected AnnotationConfigHandler() {
        ExcludeLoggers excludeLoggers = this.getClass().getAnnotation(ExcludeLoggers.class);
        this.exclusions = excludeLoggers != null && excludeLoggers.value() != null ? excludeLoggers.value() : new String[0];
        LogFormat format = this.getClass().getAnnotation(LogFormat.class);
        if (format != null && format.value() != null) {
            this.setFormatter(new CustomFormatter(format.value()));
        }
    }

    @Override
    public boolean isLoggable(LogRecord rec) {
        boolean loggable = super.isLoggable(rec);
        if (!loggable) {
            return false;
        }
        if (rec.getLoggerName() == null) {
            return true;
        }
        for (String exclusion : this.exclusions) {
            if (!rec.getLoggerName().startsWith(exclusion)) continue;
            return false;
        }
        return true;
    }
}

