/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.util.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class CustomFormatter
extends Formatter {
    private String format;
    private final Date timestamp = new Date();

    public CustomFormatter(String format) {
        this.format = format;
    }

    @Override
    public synchronized String format(LogRecord rec) {
        String source;
        this.timestamp.setTime(rec.getMillis());
        if (rec.getSourceClassName() != null) {
            source = rec.getSourceClassName();
            if (rec.getSourceMethodName() != null) {
                source = source + " " + rec.getSourceMethodName();
            }
        } else {
            source = rec.getLoggerName();
        }
        String message = this.formatMessage(rec);
        String throwable = "";
        if (rec.getThrown() != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println();
            rec.getThrown().printStackTrace(pw);
            pw.close();
            throwable = sw.toString();
        }
        return String.format(this.format, this.timestamp, source, rec.getLoggerName(), rec.getLevel().getName(), message, throwable);
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }
}

