/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.util.logging;

import io.github.albertus82.util.logging.FileHandlerConfig;
import io.github.albertus82.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EnhancedFileHandler
extends FileHandler {
    private static final Logger log = LoggerFactory.getLogger(EnhancedFileHandler.class);
    private final String pattern;
    private final int limit;
    private final int count;
    private final boolean append;

    public EnhancedFileHandler(FileHandlerConfig config) throws IOException {
        super(config.getPattern(), config.getLimit(), config.getCount(), config.isAppend());
        this.pattern = config.getPattern();
        this.limit = config.getLimit();
        this.count = config.getCount();
        this.append = config.isAppend();
        this.configure(config);
    }

    protected void configure(FileHandlerConfig config) {
        this.setLevel(config.getLevel());
        this.setFilter(config.getFilter());
        this.setFormatter(config.getFormatter());
        try {
            this.setEncoding(config.getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.WARNING, "Cannot set the character encoding used by this Handler because the named encoding is not supported:", e);
        }
    }

    public String getPattern() {
        return this.pattern;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getCount() {
        return this.count;
    }

    public boolean isAppend() {
        return this.append;
    }
}

