/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.util.logging;

import io.github.albertus82.jface.JFaceMessages;
import io.github.albertus82.util.FileSorter;
import io.github.albertus82.util.logging.ILogFileManager;
import io.github.albertus82.util.logging.LoggerFactory;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Observable;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class HousekeepingFilter
extends Observable
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(HousekeepingFilter.class);
    public static final int MIN_HISTORY = 1;
    private final ILogFileManager logFileManager;
    private final int maxHistory;
    private final String datePattern;
    private String currentFileNamePart;

    public HousekeepingFilter(ILogFileManager logFileManager, int maxHistory) {
        this(logFileManager, maxHistory, "yyyyMMdd");
    }

    public HousekeepingFilter(ILogFileManager logFileManager, int maxHistory, String datePattern) {
        this.logFileManager = logFileManager;
        if (maxHistory < 1) {
            log.log(Level.WARNING, JFaceMessages.get("err.logging.housekeeping.maxHistory"), 1);
            this.maxHistory = 1;
        } else {
            this.maxHistory = maxHistory;
        }
        new SimpleDateFormat(datePattern);
        this.datePattern = datePattern;
        log.log(Level.FINE, "Created new {0}", this);
    }

    @Override
    public boolean isLoggable(LogRecord rec) {
        String newFileNamePart = new SimpleDateFormat(this.datePattern).format(new Date());
        if (!newFileNamePart.equals(this.currentFileNamePart)) {
            int keep = this.maxHistory;
            if (this.currentFileNamePart == null) {
                ++keep;
            }
            this.currentFileNamePart = newFileNamePart;
            this.deleteOldLogs(keep);
        }
        return true;
    }

    private void deleteOldLogs(int keep) {
        File[] files = this.logFileManager.listFiles();
        if (files != null && files.length > keep) {
            FileSorter.sortByLastModified(files);
            for (int i = 0; i < files.length - keep; ++i) {
                boolean deleted = this.logFileManager.deleteFile(files[i]);
                if (!deleted) continue;
                this.setChanged();
                this.notifyObservers(files[i]);
            }
        }
    }

    public int getMaxHistory() {
        return this.maxHistory;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public String toString() {
        return "HousekeepingFilter [maxHistory=" + this.maxHistory + ", datePattern=" + this.datePattern + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.datePattern == null ? 0 : this.datePattern.hashCode());
        result = 31 * result + this.maxHistory;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HousekeepingFilter)) {
            return false;
        }
        HousekeepingFilter other = (HousekeepingFilter)obj;
        if (this.datePattern == null ? other.datePattern != null : !this.datePattern.equals(other.datePattern)) {
            return false;
        }
        return this.maxHistory == other.maxHistory;
    }
}

