/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.util.logging;

import io.github.albertus82.util.ISupplier;
import io.github.albertus82.util.Supplier;
import io.github.albertus82.util.logging.ILogFileManager;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class LogFileManager
implements ILogFileManager {
    public static final String DEFAULT_LOG_FILE_EXTENSION = ".log";
    public static final String DEFAULT_LOCK_FILE_EXTENSION = ".lck";
    private ISupplier<String> path;
    private String logFileExtension = ".log";
    private String lockFileExtension = ".lck";
    private FilenameFilter logFilenameFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name != null && (name.toLowerCase().contains(LogFileManager.this.getLogFileExtension()) || name.toLowerCase(Locale.ROOT).contains(LogFileManager.this.getLogFileExtension())) && !name.endsWith(LogFileManager.this.getLockFileExtension());
        }
    };
    private FilenameFilter lockFilenameFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name != null && name.endsWith(LogFileManager.this.getLockFileExtension());
        }
    };

    public LogFileManager(ISupplier<String> path) {
        this.path = path;
    }

    public LogFileManager(final String path) {
        this.path = new Supplier<String>(){

            @Override
            public String get() {
                return path;
            }
        };
    }

    @Override
    public File[] listFiles() {
        return new File(this.getPath()).listFiles(this.getLogFilenameFilter());
    }

    @Override
    public boolean deleteFile(File file) {
        if (this.getLockedFiles().contains(file)) {
            return false;
        }
        return file.delete();
    }

    public Set<File> getLockedFiles() {
        HashSet<File> lockedFiles = new HashSet<File>();
        File[] lockFiles = new File(this.getPath()).listFiles(this.getLockFilenameFilter());
        if (lockFiles != null) {
            for (File lockFile : lockFiles) {
                File lockedFile = new File(lockFile.getPath().replace(this.getLockFileExtension(), ""));
                if (!lockedFile.exists()) continue;
                lockedFiles.add(lockedFile);
            }
        }
        return lockedFiles;
    }

    public int deleteAllFiles() {
        int count = 0;
        File[] files = this.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) continue;
                count += this.deleteFile(file) ? 1 : 0;
            }
        }
        return count;
    }

    public String getPath() {
        return this.path.get();
    }

    public void setPath(ISupplier<String> path) {
        this.path = path;
    }

    public void setPath(final String path) {
        this.setPath((ISupplier<String>)new Supplier<String>(){

            @Override
            public String get() {
                return path;
            }
        });
    }

    public String getLogFileExtension() {
        return this.logFileExtension;
    }

    public void setLogFileExtension(String logFileExtension) {
        this.logFileExtension = logFileExtension;
    }

    public String getLockFileExtension() {
        return this.lockFileExtension;
    }

    public void setLockFileExtension(String lockFileExtension) {
        this.lockFileExtension = lockFileExtension;
    }

    public FilenameFilter getLogFilenameFilter() {
        return this.logFilenameFilter;
    }

    public void setLogFilenameFilter(FilenameFilter logFilenameFilter) {
        this.logFilenameFilter = logFilenameFilter;
    }

    public FilenameFilter getLockFilenameFilter() {
        return this.lockFilenameFilter;
    }

    public void setLockFilenameFilter(FilenameFilter lockFilenameFilter) {
        this.lockFilenameFilter = lockFilenameFilter;
    }
}

