/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.util.logging;

import io.github.albertus82.util.logging.CustomFormatter;
import io.github.albertus82.util.logging.EnhancedFileHandler;
import io.github.albertus82.util.logging.FileHandlerConfig;
import io.github.albertus82.util.logging.ILoggingConfig;
import io.github.albertus82.util.logging.ILoggingManager;
import io.github.albertus82.util.logging.LoggerFactory;
import io.github.albertus82.util.logging.LoggingSupport;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggingManager
implements ILoggingManager {
    private static final Logger log = LoggerFactory.getLogger(LoggingManager.class);
    private final ILoggingConfig loggingConfig;
    private EnhancedFileHandler fileHandler;

    public LoggingManager(ILoggingConfig loggingConfig, boolean initialize) {
        this.loggingConfig = loggingConfig;
        if (initialize) {
            this.initializeLogging();
        }
    }

    @Override
    public void initializeLogging() {
        if (LoggingSupport.getInitialConfigurationProperty() == null) {
            this.updateLoggingLevel();
            if (this.loggingConfig.isFileHandlerEnabled()) {
                this.enableLoggingFileHandler();
            } else {
                this.disableLoggingFileHandler();
            }
        }
    }

    protected void enableLoggingFileHandler() {
        String fileHandlerPattern = this.loggingConfig.getFileHandlerPattern();
        if (fileHandlerPattern != null && !fileHandlerPattern.isEmpty()) {
            FileHandlerConfig oldConfig;
            FileHandlerConfig newConfig = new FileHandlerConfig();
            newConfig.setPattern(fileHandlerPattern);
            newConfig.setLimit(this.loggingConfig.getFileHandlerLimit());
            newConfig.setCount(this.loggingConfig.getFileHandlerCount());
            newConfig.setAppend(true);
            newConfig.setFormatter(new CustomFormatter(this.loggingConfig.getFileHandlerFormat()));
            if (!(this.fileHandler == null || (oldConfig = FileHandlerConfig.fromHandler(this.fileHandler)).getPattern().equals(newConfig.getPattern()) && oldConfig.getLimit() == newConfig.getLimit() && oldConfig.getCount() == newConfig.getCount())) {
                log.log(Level.FINE, "Logging configuration has changed; closing and removing old {0}...", this.fileHandler.getClass().getSimpleName());
                LoggingSupport.getRootLogger().removeHandler(this.fileHandler);
                this.fileHandler.close();
                this.fileHandler = null;
                log.log(Level.FINE, "Old FileHandler closed and removed.");
            }
            if (this.fileHandler == null) {
                log.log(Level.FINE, "FileHandler not found; creating one...");
                try {
                    File logDir = new File(fileHandlerPattern).getParentFile();
                    if (logDir != null) {
                        logDir.mkdirs();
                    }
                    this.fileHandler = new EnhancedFileHandler(newConfig);
                    LoggingSupport.getRootLogger().addHandler(this.fileHandler);
                    log.log(Level.FINE, "{0} created successfully.", this.fileHandler.getClass().getSimpleName());
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, "An error occurred while creating the FileHandler:", e);
                }
            }
        }
    }

    protected void disableLoggingFileHandler() {
        if (this.fileHandler != null) {
            LoggingSupport.getRootLogger().removeHandler(this.fileHandler);
            this.fileHandler.close();
            this.fileHandler = null;
            log.log(Level.FINE, "FileHandler closed and removed.");
        }
    }

    protected void updateLoggingLevel() {
        try {
            LoggingSupport.setLevel(LoggingSupport.getRootLogger().getName(), Level.parse(this.loggingConfig.getLoggingLevel()));
        }
        catch (IllegalArgumentException e) {
            log.log(Level.WARNING, "Cannot update logging level:", e);
        }
    }
}

